/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.IOException;

public class ChatObject
extends CDirNameHandler {
    private static int Instance;
    private boolean amFirstInstance = false;
    private FCResource Resource = new FCResource();
    private FCUtil Util = new FCUtil();
    private FCCheckBox ChatSoundsEnabled;
    private FCScrolledEditor OutputBox;
    private FCScrolledEditor InputBox;
    private FCButton InviteButton;
    private FCButton SendButton;
    private FCList ParticipantsList;
    private FCLabel ParticipantsListLabel;
    private FCLabel InputBoxLabel;
    private FCLabel OutputBoxLabel;
    public static final int MAXCHATCHARS = 231;
    public static final int chNormal = 0;
    public static final int chEnter = 1;
    public static final int chLeave = 2;

    public ChatObject(FCPConnection fCPConnection, int n) {
        super(fCPConnection, n);
        Container container = null;
        this.amFirstInstance = Instance == 0;
        ++Instance;
        new FCUtil();
        if (!this.amFirstInstance) {
            GUIObjectParams gUIObjectParams = new GUIObjectParams(1, 100);
            Rectangle rectangle = gUIObjectParams.getRect();
            Color color = gUIObjectParams.getForegroundColor();
            Color color2 = gUIObjectParams.getBackgroundColor();
            Font font = gUIObjectParams.getFont();
            String string = gUIObjectParams.getBackgroundImage();
            this.getFrame().setTitle(gUIObjectParams.getLabel());
            ((Component)this.getFrame()).setFont(font);
            this.getFrame().move(rectangle.x, rectangle.y + 32);
            this.getFrame().resize(rectangle.width, rectangle.height);
            this.getFrame().setForeground(color);
            ((Component)this.getFrame()).setBackground(color2);
            if (string != null) {
                this.getFrame().setBackgroundImage(string);
            }
            this.getFrame().show();
        }
        container = this.getContainer();
        Debug.Print(6, "**** container=" + container + " ****\n");
        this.ChatSoundsEnabled = new FCCheckBox(1, 103);
        container.add(this.ChatSoundsEnabled);
        this.ChatSoundsEnabled.setState(true);
        this.ParticipantsListLabel = new FCLabel(1, 106);
        container.add(this.ParticipantsListLabel);
        this.ParticipantsList = new FCList(1, 107);
        container.add(this.ParticipantsList);
        this.InputBoxLabel = new FCLabel(1, 101);
        container.add(this.InputBoxLabel);
        this.InputBox = new FCScrolledEditor(this, 1, 102);
        container.add(this.InputBox);
        this.OutputBoxLabel = new FCLabel(1, 104);
        container.add(this.OutputBoxLabel);
        this.OutputBox = new FCScrolledEditor(null, 1, 105);
        this.OutputBox.setEditable(false);
        container.add(this.OutputBox);
        this.InviteButton = new FCButton(1, 108);
        container.add(this.InviteButton);
        this.InviteButton.setEventCatcher(this);
        this.SendButton = new FCButton(1, 109);
        container.add(this.SendButton);
        this.SendButton.setEventCatcher(this);
        this.ChatSoundsEnabled.show();
        this.ParticipantsListLabel.show(true);
        this.ParticipantsList.show();
        this.InputBox.show();
        this.InputBoxLabel.show(true);
        this.OutputBoxLabel.show(true);
        this.OutputBox.show();
        this.InviteButton.show();
        this.SendButton.show();
    }

    public static void setInstance(int n) {
        Instance = n;
    }

    public Container getContainer() {
        if (this.amFirstInstance) {
            return FCChat.gApplet;
        }
        return this.getFrame();
    }

    public void catchEvent(Component component, Event event) {
        Debug.Print(5, "ChatObject.catchEvent(" + component + "," + event + ")\n");
        if (component == this.InviteButton && event.id == 1001) {
            this.getConnection().DoDirectory(true, this, "", 0, 0, -1);
            return;
        }
        if (component == this.SendButton && event.id == 1001) {
            Debug.Print(5, "SendButton pressed.\n");
            this.SendTyping();
            return;
        }
        if (component == this.InputBox && event.id == 401 && event.key == 10) {
            this.SendTyping();
        }
    }

    private String removeTerminators(String string) {
        char[] cArray = string.toCharArray();
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            if (cArray[n] != '\n' && cArray[n] != '\r' || n > 0 && n < cArray.length - 1) {
                string2 = String.valueOf(string2) + cArray[n];
            }
            ++n;
        }
        return string2;
    }

    private void SendTyping() {
        String string = this.InputBox.getText();
        this.InputBox.setText("");
        string.trim();
        if (string.length() > 0 && (string = this.removeTerminators(string)).length() > 0) {
            this.SendChatText(string);
        }
    }

    long UnsignedLong(int n) {
        if (n > 0) {
            return n;
        }
        return 0x100000000L + (long)n;
    }

    private void SendChatText(String string) {
        Debug.Print(5, "SendChatText(\"" + string + "\")\n");
        byte[] byArray = new byte[]{-22, -22, 2, 58, 0, 0, 0, -20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byArray[8] = (byte)(this.GetObjID() >> 8);
        byArray[9] = (byte)(this.GetObjID() & 0xFF);
        byArray[10] = 0;
        byArray[11] = 0;
        try {
            byte[] byArray2 = FCChat.doTranslate ? string.getBytes(FCChat.LocaleCharSet) : string.getBytes();
            int n = 0;
            int n2 = 13;
            while (n < byArray2.length) {
                if (n < 230) {
                    byArray[n2] = byArray2[n];
                    byArray[12] = (byte)(byArray[12] + 1);
                    ++n;
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
        try {
            this.getConnection().SendPacket(byArray);
            return;
        }
        catch (IOException iOException) {
            FCException.handleException(iOException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void HandleReply(int n, byte[] byArray) {
        String string = null;
        Debug.Print(3, "ChatObject::HandleReply ObjID:" + this.GetObjID() + "\n");
        switch (n) {
            case 8: {
                int n2 = FCPConnection.MotorolaShort(byArray, 2);
                int n3 = FCPConnection.MotorolaShort(byArray, 4);
                FCPConnection.MotorolaShort(byArray, 6);
                switch (n2) {
                    case 22: {
                        int n4 = FCPConnection.MotorolaShort(byArray, 8);
                        int n5 = FCPConnection.MotorolaShort(byArray, 10);
                        switch (n4) {
                            case 0: {
                                int n6 = byArray[12] & 0x7F;
                                if ((byArray[12] & 0x80) == 128) {
                                    n6 += 128;
                                }
                                if (FCChat.doTranslate) {
                                    try {
                                        string = new String(byArray, 13, n6, FCChat.LocaleCharSet);
                                    }
                                    catch (Exception exception) {
                                        FCException.handleException(exception);
                                    }
                                } else {
                                    try {
                                        string = new String(byArray, 0, 13, n6);
                                    }
                                    catch (Exception exception) {
                                        FCException.handleException(exception);
                                    }
                                }
                                if (n5 < this.ParticipantsList.countItems()) {
                                    this.OutputBox.appendText(String.valueOf(this.ParticipantsList.getItem(n5)) + ": " + string);
                                } else {
                                    this.OutputBox.appendText(String.valueOf(n5) + ": " + string);
                                }
                                this.OutputBox.appendText("\n");
                                if (!this.ChatSoundsEnabled.getState() || FCChat.snd129 == null) return;
                                FCChat.snd129.play();
                                return;
                            }
                            case 1: {
                                byte by = byArray[12];
                                string = FCResource.SAGetIndString(133, 2);
                                if (n5 < this.ParticipantsList.countItems()) {
                                    this.OutputBox.appendText(String.valueOf(this.ParticipantsList.getItem(n5)) + " " + string);
                                } else {
                                    this.OutputBox.appendText(String.valueOf(n5) + " " + string);
                                }
                                this.OutputBox.appendText("\n");
                                if (!this.ChatSoundsEnabled.getState() || FCChat.snd130 == null) return;
                                FCChat.snd130.play();
                                return;
                            }
                            case 2: {
                                byte by = byArray[12];
                                string = FCResource.SAGetIndString(133, 3);
                                if (n5 < this.ParticipantsList.countItems()) {
                                    this.OutputBox.appendText(String.valueOf(this.ParticipantsList.getItem(n5)) + " " + string);
                                    this.ParticipantsList.delItem(n5);
                                } else {
                                    this.OutputBox.appendText(String.valueOf(n5) + " " + string);
                                }
                                this.OutputBox.appendText("\n");
                                if (!this.ChatSoundsEnabled.getState() || FCChat.snd131 == null) return;
                                FCChat.snd131.play();
                                return;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    case 23: {
                        byte by = byArray[8];
                        if (FCChat.doTranslate) {
                            try {
                                string = new String(byArray, 9, (int)by, FCCharset.s2u(FCChat.SysCharSet));
                            }
                            catch (Exception exception) {
                                FCException.handleException(exception);
                            }
                        } else {
                            try {
                                string = new String(byArray, 0, 9, (int)by);
                            }
                            catch (Exception exception) {
                                FCException.handleException(exception);
                            }
                        }
                        this.ParticipantsList.addItem(string, n3);
                        return;
                    }
                    default: {
                        Debug.Print(3, "ChatObject: Unhandled ObjDatatype:" + n2 + "\n");
                    }
                }
                return;
            }
        }
        Debug.Print(3, "ChatObject: Unhandled reply:" + n + "\n");
    }

    public void finalize() {
        Instance = 0;
    }
}

