/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import sun.misc.BASE64Decoder;

public class FCPConnection {
    private static final int MAXINNAME = 41;
    Socket fcskt;
    InputStream is;
    OutputStream os;
    Hashtable FCObjTable = new Hashtable();
    int XmitSeq;
    public String UserName = "";
    public String UserPassword = "";
    public String UserURL = "";
    public int UserPort = 510;
    FCUtil Util = new FCUtil();
    private boolean IsLoggedIn = false;
    int HdrBytesRead;
    int PktDataSize;
    byte[] hdr = new byte[8];
    byte[] PktData;

    public void Run() {
        while (true) {
            this.Run(1);
        }
    }

    public void Run(int n) {
        byte[] byArray = null;
        while (n-- > 0) {
            byArray = this.ReadPacket();
            if (byArray == null) {
                Thread.yield();
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    FCException.handleException(exception);
                }
                continue;
            }
            this.HandleReply((byte)(this.hdr[3] & 0x7F), byArray);
        }
    }

    public boolean getLoginState(int n) {
        if (this.IsLoggedIn) {
            return true;
        }
        this.Run(n);
        return this.IsLoggedIn;
    }

    public boolean getLoginState() {
        return this.IsLoggedIn;
    }

    public boolean Connect(String string, String string2, String string3, String string4, String string5) {
        try {
            Object object;
            Object object2;
            if (string2.length() > 0) {
                object2 = new BASE64Decoder();
                try {
                    object = object2.decodeBuffer(string3);
                    this.UserPassword = new String((byte[])object, 0, ((Object)object).length);
                }
                catch (Exception exception) {
                    FCException.handleException(exception);
                }
                this.UserName = string2.trim();
                if (this.UserName.length() > 15) {
                    this.UserName = this.UserName.substring(0, 14);
                }
                if (this.UserPassword.length() > 14) {
                    this.UserPassword = this.UserPassword.substring(0, 13);
                }
            }
            object = InetAddress.getByName(string);
            this.UserURL = string4;
            try {
                if (string5.length() > 0) {
                    this.UserPort = new Integer(string5);
                }
            }
            catch (Exception exception) {
                FCException.handleException(exception);
            }
            object2 = new Socket((InetAddress)object, this.UserPort);
            Debug.Print(2, "Connected.\n");
            this.is = ((Socket)object2).getInputStream();
            this.os = ((Socket)object2).getOutputStream();
            byte[] byArray = new byte[]{-22, -22, 0, 51, -79, 91, 0, 20, -127, 103, 91, 73, 6, 80, 87, -44, 104, 88, -25, -65, -117, 123, -34, -81, -21, 93, -27, -75};
            this.SendPacket(byArray);
            Debug.Print(2, "Connection Request  sent\n");
            return true;
        }
        catch (Exception exception) {
            FCException.handleException(exception);
            return false;
        }
    }

    private void Logout() throws IOException {
        Debug.Print(2, "Logout ");
        byte[] byArray = new byte[]{-22, -22, 2, 5, 0, 0, 0, 0};
        this.SendPacket(byArray);
        int n = 4;
        Debug.Print(2, "waiting for reply ");
        while (this.IsLoggedIn && n > 0) {
            Debug.Print(2, ".");
            this.Run(10);
            --n;
        }
        if (n <= 0) {
            Debug.Print(2, "timed out\n");
            return;
        }
        Debug.Print(2, "ok\n");
    }

    public void Disconnect() {
        Debug.Print(2, "Disconnect()");
        try {
            this.Logout();
            this.is.close();
            this.os.close();
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
        this.is = null;
        this.os = null;
    }

    int CalcCS4(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        int n3 = n / 4;
        int n4 = 0;
        while (n3 > 0) {
            n2 += FCPConnection.MotorolaLong(byArray, n4);
            --n3;
            n4 += 4;
        }
        if (n4 < n) {
            n2 += FCPConnection.Unsigned(byArray[n4++]) << 24;
        }
        if (n4 < n) {
            n2 += FCPConnection.Unsigned(byArray[n4++]) << 16;
        }
        if (n4 < n) {
            n2 += FCPConnection.Unsigned(byArray[n4++]) << 8;
        }
        return (n2 >> 16) + n2 & 0xFFFF;
    }

    public void SendPacket(byte[] byArray) throws IOException {
        byArray[2] = (byte)this.XmitSeq++;
        byArray[4] = 0;
        byArray[5] = 0;
        int n = this.CalcCS4(byArray);
        byArray[4] = (byte)(n >> 8);
        byArray[5] = (byte)(n & 0xFF);
        Debug.Print(8, "SendPacket Cmd:" + byArray[3] + "\n");
        Debug.PrintHexBytes(8, this.hdr);
        Debug.Print(8, "\n");
        this.os.write(byArray);
    }

    public void OpenObjectRequest(int n, int n2, int n3, String string, int n4) {
        byte[] byArray = new byte[]{-22, -22, 2, 7, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0};
        byArray[8] = (byte)(n >> 8);
        byArray[9] = (byte)(n & 0xFF);
        byArray[10] = (byte)(n2 >> 8);
        byArray[11] = (byte)(n2 & 0xFF);
        byArray[12] = (byte)(n4 >> 8);
        byArray[13] = (byte)(n4 & 0xFF);
        try {
            this.SendPacket(byArray);
            return;
        }
        catch (Exception exception) {
            FCException.handleException(exception);
            return;
        }
    }

    public void OpenObjectRequest(int n, int n2, int n3, String string) {
        this.OpenObjectRequest(n, n2, n3, string, 0);
    }

    public void OpenObject(int n, int n2) throws IOException {
        Debug.Print(3, "OpenObject ObjID:" + n + " Index:" + n2 + "\n");
        byte[] byArray = new byte[]{-22, -22, 2, 7, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0};
        byArray[8] = (byte)(n >> 8);
        byArray[9] = (byte)(n & 0xFF);
        byArray[10] = (byte)(n2 >> 8);
        byArray[11] = (byte)(n2 & 0xFF);
        this.SendPacket(byArray);
    }

    public void OpenURL(String string, int n) throws IOException {
        Debug.Print(3, "OpenURL URL:[" + string + "] Index:" + n + "\n");
        byte[] byArray = new byte[]{-22, -22, 2, 68, 0, 0, 0, -20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byArray[10] = 0;
        byArray[11] = 1;
        PackOOQ packOOQ = new PackOOQ();
        int n2 = packOOQ.PackOOQPath(byArray, 12, string);
        Debug.Print(5, "nDataPacked = " + n2 + "\n");
        byArray[8] = (byte)(n2 >> 8);
        byArray[9] = (byte)(n2 & 0xFF);
        Debug.Print(5, "OpenObject Packet:\n");
        Debug.PrintHexBytes(5, byArray);
        Debug.Print(5, "\n");
        this.SendPacket(byArray);
    }

    public void CloseObject(int n) throws IOException {
        Debug.Print(3, "CloseObject ObjID:" + n + "\n");
        byte[] byArray = new byte[]{-22, -22, 2, 12, 0, 0, 0, 4, 0, 0, 0, 0};
        byArray[8] = (byte)(n >> 8);
        byArray[9] = (byte)(n & 0xFF);
        byArray[10] = 0;
        byArray[11] = 0;
        this.SendPacket(byArray);
        this.FCObjTable.remove(new Integer(n));
    }

    static final int Unsigned(byte by) {
        return by & 0xFF;
    }

    static final int MotorolaShort(byte[] byArray, int n) {
        int n2 = ((char)byArray[n] << 8) + ((char)byArray[n + 1] & 0xFF);
        return n2;
    }

    static final int MotorolaLong(byte[] byArray, int n) {
        int n2 = (FCPConnection.Unsigned(byArray[n]) << 24) + (FCPConnection.Unsigned(byArray[n + 1]) << 16) + (FCPConnection.Unsigned(byArray[n + 2]) << 8) + FCPConnection.Unsigned(byArray[n + 3]);
        return n2;
    }

    public byte[] ReadPacket() {
        try {
            if (this.HdrBytesRead == 0 && this.is.available() >= 8) {
                this.is.read(this.hdr);
                if (this.hdr[0] != -22 || this.hdr[1] != -22) {
                    Debug.Print(7, "ReadPacket header out of sync:\n");
                    Debug.PrintHexBytes(7, this.hdr);
                    Debug.Print(7, "\n");
                    return null;
                }
                this.PktDataSize = FCPConnection.MotorolaShort(this.hdr, 6);
                Debug.Print(8, "PktDataSize:" + this.PktDataSize + "\n");
                this.HdrBytesRead = 8;
            }
            if (this.HdrBytesRead == 8 && this.is.available() >= this.PktDataSize) {
                this.PktData = new byte[this.PktDataSize];
                this.is.read(this.PktData);
                Debug.Print(8, "Got a packet:");
                Debug.PrintHexBytes(8, this.PktData);
                Debug.Print(8, "\n");
                this.HdrBytesRead = 0;
                return this.PktData;
            }
            return null;
        }
        catch (Exception exception) {
            FCException.handleException(exception);
            return null;
        }
    }

    FCServerObject NewByObjType(int n, int n2) {
        CDirNameHandler cDirNameHandler = null;
        Debug.Print(3, "NewByObjType ObjType=" + n + " ObjID=" + n2 + "\n");
        switch (n) {
            case 7: {
                cDirNameHandler = new CDirList(this, n2);
                break;
            }
            case 14: {
                cDirNameHandler = new ChatObject(this, n2);
                break;
            }
            case 15: {
                cDirNameHandler = new ChatInvite(this, n2);
                break;
            }
        }
        return cDirNameHandler;
    }

    public void HandleReply(byte by, byte[] byArray) {
        Debug.Print(3, "FCPConnection::HandleReply:" + by + "\n");
        try {
            switch (by) {
                case 51: {
                    Debug.Print(3, "ConnReq\n");
                    byte[] byArray2 = new byte[]{-22, -22, 1, 4, -126, 124, 0, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 21, 124, -108, 0, 4, -22};
                    if (this.UserName.length() > 0) {
                        this.Util.ModifyMemFromString(byArray2, 8, this.Util.String2PStr(this.UserName));
                        this.Util.ModifyMemFromString(byArray2, 24, this.Util.String2PStr(this.UserPassword));
                    } else {
                        byArray2[43] = (byte)(byArray2[43] | 0x20);
                    }
                    try {
                        Integer n = new Integer(FCCharset.u2s(FCChat.LocaleCharSet));
                        Debug.Print(2, "locale in FC charset =" + n + "\n");
                        byArray2[44] = (byte)(n >> 8);
                        byArray2[45] = (byte)(n & 0xFF);
                    }
                    catch (Exception exception) {
                        FCException.handleException(exception);
                    }
                    this.SendPacket(byArray2);
                    return;
                }
                case 4: {
                    Debug.Print(3, "Login Reply...\n");
                    int n = FCPConnection.MotorolaShort(byArray, 0);
                    if (n != 0) {
                        this.IsLoggedIn = false;
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(n);
                        fCErrorDialog.waitForAction();
                        fCErrorDialog.ClosePressed();
                        return;
                    }
                    Integer n2 = new Integer(FCPConnection.MotorolaShort(byArray, 32));
                    FCChat.SysCharSet = n2.toString();
                    Debug.Print(2, "server charset = " + FCChat.SysCharSet + "\n");
                    FCCharset.setServerCharset(FCChat.SysCharSet);
                    this.IsLoggedIn = true;
                    if (this.UserURL.length() == 0) {
                        this.OpenObject(7, 0);
                        return;
                    }
                    Debug.Print(4, "OpenURL(" + this.UserURL + ")\n");
                    this.OpenURL(this.UserURL, 0);
                    return;
                }
                case 5: {
                    Debug.Print(3, "Logout Reply...\n");
                    this.IsLoggedIn = false;
                    return;
                }
                case 62: {
                    Debug.Print(3, "cObjOpenDup\n");
                    return;
                }
                case 7: {
                    Debug.Print(3, "cObjOpen...\n");
                    Debug.PrintHexBytes(3, byArray);
                    int n = FCPConnection.MotorolaShort(byArray, 0);
                    if (n != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(n);
                        fCErrorDialog.waitForAction();
                        fCErrorDialog.ClosePressed();
                        return;
                    }
                    int n3 = FCPConnection.Unsigned(byArray[2]);
                    int n4 = FCPConnection.MotorolaShort(byArray, 4);
                    int n5 = FCPConnection.MotorolaShort(byArray, 6);
                    Debug.Print(5, "ObjOpenReply (cObjOpen) rc:" + n + " ObjType:" + n3 + " ObjID:" + n4 + " ReqID:" + n5 + "\n");
                    FCServerObject fCServerObject = this.NewByObjType(n3, n4);
                    this.FCObjTable.put(new Integer(n4), fCServerObject);
                    return;
                }
                case 68: {
                    Debug.Print(3, "cObjOpenQuery...\n");
                    Debug.PrintHexBytes(3, byArray);
                    int n = FCPConnection.MotorolaShort(byArray, 0);
                    if (n != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(n);
                        fCErrorDialog.waitForAction();
                        fCErrorDialog.ClosePressed();
                        return;
                    }
                    int n6 = FCPConnection.Unsigned(byArray[10]);
                    int n7 = FCPConnection.MotorolaShort(byArray, 12);
                    int n8 = FCPConnection.MotorolaShort(byArray, 14);
                    FCServerObject fCServerObject = this.NewByObjType(n6, n7);
                    this.FCObjTable.put(new Integer(n7), fCServerObject);
                    return;
                }
                case 8: {
                    int n = FCPConnection.MotorolaShort(byArray, 0);
                    Debug.Print(3, "cObjData ObjID=" + n + "\n");
                    FCServerObject fCServerObject = (FCServerObject)this.FCObjTable.get(new Integer(n));
                    if (fCServerObject != null) {
                        fCServerObject.HandleReply(by, byArray);
                        return;
                    }
                    Debug.Print(2, "ObjID:" + n + " not found \n");
                    return;
                }
                case 59: {
                    int n = FCPConnection.MotorolaShort(byArray, 2);
                    int n9 = 7;
                    int n10 = FCPConnection.MotorolaShort(byArray, 6);
                    FCServerObject fCServerObject = this.NewByObjType(n9, n);
                    this.FCObjTable.put(new Integer(n), fCServerObject);
                    return;
                }
                case 58: {
                    Debug.Print(3, "cChat\n");
                    return;
                }
                case 12: {
                    Debug.Print(3, "cObjClose\n");
                    int n = FCPConnection.MotorolaShort(byArray, 0);
                    if (n != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(n);
                        fCErrorDialog.waitForAction();
                        fCErrorDialog.ClosePressed();
                        return;
                    }
                    int n11 = FCPConnection.MotorolaShort(byArray, 2);
                    FCServerObject fCServerObject = (FCServerObject)this.FCObjTable.get(new Integer(n11));
                    if (fCServerObject != null) {
                        fCServerObject.HandleReply(by, byArray);
                        return;
                    }
                    break;
                }
                case 34: {
                    int n = FCPConnection.MotorolaShort(byArray, 0);
                    Debug.Print(3, "cSelect rc: " + n + "\n");
                    if (n != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(n);
                        fCErrorDialog.waitForAction();
                        fCErrorDialog.ClosePressed();
                        return;
                    }
                    break;
                }
                case 60: {
                    Debug.Print(3, "cObjOpenUnsol\n");
                    int n = FCPConnection.MotorolaShort(byArray, 0);
                    if (n != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(n);
                        fCErrorDialog.waitForAction();
                        fCErrorDialog.ClosePressed();
                        return;
                    }
                    int n12 = FCPConnection.Unsigned(byArray[2]);
                    int n13 = FCPConnection.MotorolaShort(byArray, 4);
                    int n14 = FCPConnection.MotorolaShort(byArray, 6);
                    FCServerObject fCServerObject = this.NewByObjType(n12, n13);
                    this.FCObjTable.put(new Integer(n13), fCServerObject);
                    return;
                }
                default: {
                    Debug.Print(3, "Unhandled reply:" + by + "\n");
                    return;
                }
                case 39: 
                case 48: 
                case 54: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
    }

    public void DoDirectory(boolean bl, FCServerObject fCServerObject, String string, int n, int n2, int n3) {
        byte[] byArray = new byte[]{-22, -22, 2, 59, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Debug.Print(3, "DoDirectory( index=" + n + " ObjID=" + n3 + " LinkToObj.ObjID=" + fCServerObject.GetObjID() + "\n");
        byArray[8] = (byte)(fCServerObject.GetObjID() >> 8);
        byArray[9] = (byte)(fCServerObject.GetObjID() & 0xFF);
        byArray[12] = (byte)(n >> 8);
        byArray[13] = (byte)(n & 0xFF);
        try {
            this.SendPacket(byArray);
            return;
        }
        catch (Exception exception) {
            FCException.handleException(exception);
            return;
        }
    }
}

