/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;

public class FCScrollPane
extends FCPanel {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private static int sbDisplayPolicy;
    private static FCScrollbar sbH;
    private static FCScrollbar sbV;

    public FCScrollPane() {
        this(0);
    }

    public FCScrollPane(int n) {
        sbDisplayPolicy = n;
        sbH = new FCScrollbar(this, 0);
        sbV = new FCScrollbar(this, 1);
        sbH.setValues(0, 1, 0, 1);
        sbV.setValues(0, 1, 0, 1);
        this.setLayout(null);
        this.add(sbH);
        this.add(sbV);
    }

    public void catchEvent(Component component, Event event) {
        super.catchEvent(component, event);
        if (component == sbH || component == sbV) {
            this.setScrollPosition(sbH.getValue(), sbV.getValue());
        }
    }

    protected int documentHLineIncrement() {
        return 1;
    }

    protected int documentVLineIncrement() {
        return 1;
    }

    protected int documentHPageIncrement() {
        return 10;
    }

    protected int documentVPageIncrement() {
        return 10;
    }

    protected int documentWidth() {
        return 0;
    }

    protected int documentHeight() {
        return 0;
    }

    public FCScrollbar getHAdjustable() {
        return sbH;
    }

    public FCScrollbar getVAdjustable() {
        return sbV;
    }

    public int getHScrollbarHeight() {
        return FCScrollPane.sbH.size().height;
    }

    public int getVScrollbarWidth() {
        return FCScrollPane.sbV.size().width;
    }

    public int getScrollbarDisplayPolicy() {
        return sbDisplayPolicy;
    }

    public void setScrollPosition(int n, int n2) {
        if (sbH.getValue() != n) {
            sbH.setValues(n, this.documentWidth() - this.getViewportSize().width, 0, this.documentWidth());
        }
        if (sbV.getValue() != n2) {
            sbV.setValues(n2, this.documentHeight() - this.getViewportSize().height, 0, this.documentHeight());
        }
    }

    public void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public Point getScrollPosition() {
        Point point = new Point(sbH.getValue(), sbV.getValue());
        return point;
    }

    public Dimension getViewportSize() {
        int n = 0;
        int n2 = 0;
        if (sbV.isVisible()) {
            n = FCScrollPane.sbV.size().width;
        }
        if (sbH.isVisible()) {
            n2 = FCScrollPane.sbH.size().height;
        }
        Dimension dimension = new Dimension(this.size().width - n, this.size().height - n2);
        return dimension;
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        if (n != this.size().width || n2 != this.size().height) {
            this.drawScrollbars();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawScrollbars();
    }

    private void drawScrollbars() {
        if (FCScrollPane.sbH.size().height <= 0) {
            sbH.resize(FCScrollPane.sbH.size().width, 16);
        }
        if (FCScrollPane.sbV.size().height <= 0) {
            sbV.resize(16, FCScrollPane.sbH.size().height);
        }
        switch (sbDisplayPolicy) {
            case 1: {
                sbH.move(0, this.size().height - FCScrollPane.sbH.size().height);
                sbH.resize(this.size().width - FCScrollPane.sbV.size().width, FCScrollPane.sbH.size().height);
                if (!sbH.isVisible()) {
                    sbH.show();
                }
                sbV.move(this.size().width - FCScrollPane.sbV.size().width, 0);
                sbV.resize(FCScrollPane.sbV.size().width, this.size().height - FCScrollPane.sbH.size().height);
                if (sbV.isVisible()) break;
                sbV.show();
                break;
            }
            case 0: {
                if (this.documentWidth() > this.size().width) {
                    sbH.move(0, this.size().height - FCScrollPane.sbH.size().height);
                    if (this.documentHeight() > this.size().height) {
                        sbH.resize(this.size().width - FCScrollPane.sbV.size().width, FCScrollPane.sbH.size().height);
                    } else {
                        sbH.resize(this.size().width, FCScrollPane.sbH.size().height);
                    }
                    sbH.show();
                } else {
                    sbH.hide();
                }
                if (this.documentHeight() > this.size().height) {
                    sbV.move(this.size().width - FCScrollPane.sbV.size().width, 0);
                    if (this.documentWidth() > this.size().width) {
                        sbV.resize(FCScrollPane.sbV.size().width, this.size().height - FCScrollPane.sbH.size().height);
                    } else {
                        sbV.resize(FCScrollPane.sbV.size().width, this.size().height);
                    }
                    sbV.show();
                    break;
                }
                sbV.hide();
                break;
            }
            default: {
                if (sbH.isVisible()) {
                    sbH.hide();
                }
                if (!sbV.isVisible()) break;
                sbV.hide();
            }
        }
        if (sbH.isVisible()) {
            sbH.setLineIncrement(this.documentHLineIncrement());
            sbH.setPageIncrement(this.documentHPageIncrement());
            sbH.setValues(sbH.getValue(), this.documentWidth() - this.getViewportSize().width, 0, this.documentWidth());
        }
        if (sbV.isVisible()) {
            sbV.setLineIncrement(this.documentVLineIncrement());
            sbV.setPageIncrement(this.documentVPageIncrement());
            sbV.setValues(sbV.getValue(), this.documentHeight() - this.getViewportSize().height, 0, this.documentHeight());
        }
    }

    static {
        sbH = null;
        sbV = null;
    }
}

