/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;

public class FCServerObject
implements FrameOwner {
    private int ObjID;
    private FCPConnection MyConnection;
    private FCFrame MyFrame;

    public FCServerObject() {
    }

    public FCServerObject(FCPConnection fCPConnection, int n) {
        this.ObjID = n;
        this.MyConnection = fCPConnection;
    }

    public FCServerObject(FCPConnection fCPConnection, int n, boolean bl) {
        this.ObjID = n;
        this.MyConnection = fCPConnection;
        if (bl) {
            this.MyFrame = new FCFrame(this);
        }
    }

    public int GetObjID() {
        return this.ObjID;
    }

    public FCPConnection getConnection() {
        return this.MyConnection;
    }

    public FCFrame getFrame() {
        return this.MyFrame;
    }

    public void catchEvent(Component component, Event event) {
        Debug.Print(4, "Unhandled event: " + event.toString() + "\n");
    }

    public void OpenIndex(int n) throws IOException {
        this.MyConnection.OpenObject(this.ObjID, n);
    }

    public void Close() throws IOException {
        this.MyConnection.CloseObject(this.ObjID);
    }

    public void ClosePressed() {
        try {
            this.getFrame().dispose();
            this.Close();
            return;
        }
        catch (Exception exception) {
            FCException.handleException(exception);
            return;
        }
    }

    public void HandleReply(int n, byte[] byArray) {
        Debug.Print(2, "FCServerObject: unhandled reply: " + n + "\n");
    }

    public void peekEvent(Event event) {
    }

    public void paint(Graphics graphics) {
    }

    public void repaint() {
        this.MyFrame.repaint();
    }

    public void show() {
        this.MyFrame.show();
    }

    public void hide() {
        ((Component)this.MyFrame).hide();
    }

    public Rectangle bounds() {
        return this.MyFrame.bounds();
    }

    public void resize(int n, int n2) {
        this.MyFrame.resize(n, n2);
    }

    public void resize(Dimension dimension) {
        this.MyFrame.resize(dimension);
    }

    public void setBackgroundImage(String string) {
        this.MyFrame.setBackgroundImage(string);
    }

    public void setTitle(String string) {
        this.MyFrame.setTitle(string);
    }

    public String getTitle() {
        return this.MyFrame.getTitle();
    }
}

