/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class FCTable
extends FCScrollPane {
    private int[] rowSelected = new int[1];
    private Image[] icon;
    private String[] text;
    private int[] attr;
    private int rowCount;
    private int rowHeight = 18;
    private int topRow;
    private int textCol = 16;
    private FCScrollbar hAdjustable;
    private FCScrollbar vAdjustable;
    private FCImageLoader imageLoader;
    private boolean multiON = false;
    private boolean isFocus = false;

    public FCTable() {
        this.rowSelected[0] = -1;
        this.rowHeight = 18;
        this.topRow = 0;
        this.hAdjustable = this.getHAdjustable();
        this.vAdjustable = this.getVAdjustable();
        this.setBackground(new Color(255, 255, 255));
        this.setForeground(new Color(0, 0, 0));
        this.enable();
    }

    public int addItem(int n, String string, int n2) {
        Image[] imageArray = new Image[this.rowCount + 1];
        String[] stringArray = new String[this.rowCount + 1];
        int[] nArray = new int[this.rowCount + 1];
        int n3 = 0;
        while (n3 < this.rowCount) {
            imageArray[n3] = this.icon[n3];
            stringArray[n3] = this.text[n3];
            nArray[n3] = this.attr[n3];
            ++n3;
        }
        imageArray[this.rowCount] = FCChat.getCICN(n);
        stringArray[this.rowCount] = string;
        nArray[this.rowCount] = n2;
        this.icon = imageArray;
        this.text = stringArray;
        this.attr = nArray;
        if (this.rowCount++ == 0) {
            this.rowHeight = this.getFontMetrics(this.getFont()).getHeight();
            this.setScrollPosition(0, 0);
        }
        return this.rowCount - 1;
    }

    public void clear() {
        this.rowSelected[0] = -1;
        this.icon = null;
        this.text = null;
        this.attr = null;
        this.rowCount = 0;
        this.topRow = 0;
        this.repaint();
    }

    public void setScrollPosition(int n, int n2) {
        int n3 = n2 / this.rowHeight;
        if (n3 != this.topRow) {
            this.topRow = n3;
            super.setScrollPosition(n, n2);
            this.repaint();
        }
    }

    public void setMulti(boolean bl) {
        this.multiON = bl;
    }

    public boolean isMultiSelect() {
        return this.multiON;
    }

    public int countSelected() {
        int n = 0;
        if (this.multiON) {
            n = this.rowSelected.length;
        } else if (this.rowSelected[0] >= 0) {
            n = 1;
        }
        return n;
    }

    public int[] getSelectedRows() {
        return this.rowSelected;
    }

    public void deselectRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            if (this.isSelected(n)) {
                if (this.multiON && this.countSelected() > 1) {
                    int[] nArray = new int[this.countSelected() - 1];
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < this.countSelected()) {
                        if (this.rowSelected[n3] != n) {
                            nArray[n2++] = this.rowSelected[n3];
                        }
                        ++n3;
                    }
                    this.rowSelected = nArray;
                } else if (this.rowSelected[0] == n) {
                    this.rowSelected[0] = -1;
                }
            }
            this.drawRow(this.getGraphics(), n, 0, this.getRowY(n));
        }
        this.drawFocusRect(this.getGraphics());
    }

    public void selectRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            if (!this.isSelected(n)) {
                if (this.multiON && n >= 0) {
                    if (this.countSelected() == 0) {
                        this.rowSelected[0] = n;
                    } else {
                        int[] nArray = new int[this.countSelected() + 1];
                        int n2 = 0;
                        while (n2 < this.countSelected()) {
                            nArray[n2] = this.rowSelected[n2];
                            ++n2;
                        }
                        nArray[this.countSelected()] = n;
                        this.rowSelected = nArray;
                    }
                } else if (!this.multiON) {
                    this.deselectRow(this.rowSelected[0]);
                    this.rowSelected[0] = n;
                }
            }
            this.drawRow(this.getGraphics(), n, 0, this.getRowY(n));
        }
        this.drawFocusRect(this.getGraphics());
    }

    public boolean isSelected(int n) {
        boolean bl = false;
        if (!this.multiON && this.rowSelected[0] == n && n >= 0) {
            bl = true;
        }
        return bl;
    }

    public void deselectAll() {
        if (this.multiON) {
            int[] nArray = this.getSelectedRows();
            int n = this.countSelected();
            int n2 = 0;
            while (n2 < n) {
                this.deselectRow(nArray[n2]);
                ++n2;
            }
            return;
        }
        this.deselectRow(this.getRowSelected());
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getRowSelected() {
        return this.rowSelected[0];
    }

    public int getRowY(int n) {
        return (n - this.topVisibleRow()) * this.rowHeight;
    }

    public int topVisibleRow() {
        return this.topRow;
    }

    public int bottomVisibleRow() {
        int n = this.getViewportSize().height;
        n = n <= this.rowHeight ? 0 : (n /= this.rowHeight);
        int n2 = this.topVisibleRow() + n;
        if (n2 > this.rowCount) {
            n2 = this.rowCount;
        }
        return n2;
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        if (n != this.size().width || n2 != this.size().height) {
            this.setScrollPosition(0, 0);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.redraw(graphics);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(Event event) {
        boolean bl = super.handleEvent(event);
        boolean bl2 = false;
        int n = 0;
        block0 : switch (event.id) {
            case 1004: {
                Graphics graphics = this.getGraphics();
                this.isFocus = true;
                if (this.getRowSelected() >= 0) {
                    int n2 = this.getRowSelected();
                    int n3 = this.getRowY(n2);
                    int n4 = 0;
                    this.drawRow(graphics, n2, n4, n3);
                }
                this.drawFocusRect(graphics);
                break;
            }
            case 1005: {
                Graphics graphics = this.getGraphics();
                if (graphics == null) break;
                this.isFocus = false;
                this.drawFocusRect(graphics);
                break;
            }
            case 401: 
            case 403: {
                switch (event.key) {
                    case 1005: {
                        int n5 = this.topRow;
                        n = this.getRowSelected();
                        this.selectRow(n + 1);
                        if (this.getRowSelected() < 0) break block0;
                        while (this.getRowSelected() >= this.bottomVisibleRow()) {
                            ++this.topRow;
                        }
                        if (n5 == this.topRow) break block0;
                        this.repaint();
                        break block0;
                    }
                    case 1004: {
                        int n6 = this.topRow;
                        n = this.getRowSelected();
                        this.selectRow(n - 1);
                        if (this.getRowSelected() < 0) break block0;
                        while (this.getRowSelected() < this.topVisibleRow() && this.topVisibleRow() >= 0) {
                            --this.topRow;
                        }
                        if (n6 == this.topRow) break block0;
                        this.repaint();
                        break block0;
                    }
                    case 10: 
                    case 32: {
                        bl2 = true;
                        break block0;
                    }
                    default: {
                        if (!bl2) return bl;
                    }
                }
            }
            case 501: {
                this.requestFocus();
                if ((event.modifiers | 1) == 0 || event.clickCount > 1) {
                    this.deselectAll();
                }
                this.selectRow(this.topVisibleRow() + event.y / this.rowHeight);
                if (event.clickCount <= 1) break;
                bl2 = true;
                break;
            }
        }
        if (!bl2) return bl;
        this.doubleClick(event, event.x, event.y);
        return bl;
    }

    protected void doubleClick(Event event, int n, int n2) {
    }

    protected int documentHLineIncrement() {
        return 1;
    }

    protected int documentVLineIncerement() {
        return this.rowHeight;
    }

    protected int documentHPageIncrement() {
        return 12;
    }

    protected int documentVPageIncrement() {
        return this.rowHeight;
    }

    protected int documentWidth() {
        return 100;
    }

    protected int documentHeight() {
        return this.getRowCount() * this.rowHeight;
    }

    private void redraw(Graphics graphics) {
        int n = this.bottomVisibleRow();
        int n2 = this.topVisibleRow();
        while (n2 < n) {
            int n3 = this.getRowY(n2);
            int n4 = 0;
            this.drawRow(graphics, n2, n4, n3);
            ++n2;
        }
        this.drawFocusRect(graphics);
    }

    private void drawRow(Graphics graphics, int n, int n2, int n3) {
        if (n >= 0 && n < this.getRowCount() && n >= this.topVisibleRow() && n <= this.bottomVisibleRow()) {
            this.eraseRow(graphics, n, n2, n3);
            this.paintRow(graphics, n, n2, n3);
        }
    }

    private void eraseRow(Graphics graphics, int n, int n2, int n3) {
        if (this.isSelected(n)) {
            graphics.setColor(new Color(0, 0, 0));
        } else {
            graphics.setColor(new Color(255, 255, 255));
        }
        graphics.fillRect(n2, n3, this.getViewportSize().width, this.rowHeight);
    }

    private void paintRow(Graphics graphics, int n, int n2, int n3) {
        Font font = new Font(this.getFont().getName(), this.attr[n], this.getFont().getSize());
        graphics.setFont(font);
        if (this.icon != null) {
            Image image = this.icon[n];
            this.imageLoader = new FCImageLoader(this);
            this.imageLoader.loadImage(image);
            this.imageLoader.waitForImage(image);
            graphics.drawImage(image, n2 + 2, n3, null);
        }
        if (this.text != null) {
            if (this.isSelected(n)) {
                graphics.setColor(new Color(255, 255, 255));
            } else {
                graphics.setColor(new Color(0, 0, 0));
            }
            graphics.drawString(this.text[n], n2 + this.textCol, n3 + graphics.getFontMetrics(graphics.getFont()).getAscent());
        }
    }

    private void eraseFocusRect(Graphics graphics) {
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawRect(1, 1, this.size().width - 3, this.size().height - 3);
    }

    private void drawFocusRect(Graphics graphics) {
        this.eraseFocusRect(graphics);
        graphics.setColor(new Color(0, 0, 0));
        graphics.drawRect(0, 0, this.size().width - 1, this.size().height - 1);
        if (this.isFocus) {
            graphics.drawRect(1, 1, this.size().width - 3, this.size().height - 3);
        }
    }
}

