/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.IOException;

public class CDirList
extends CDirNameHandler {
    private static final int MAXONAME = 23;
    private static final int MAXNAME = 23;
    FCUtil Util = new FCUtil();
    FCResource Resource = new FCResource();
    DirNameList MyDirList;
    FCButton SelectButton;
    private boolean GotEOF = true;

    public CDirList(FCPConnection fCPConnection, int n) {
        super(fCPConnection, n);
        GUIObjectParams gUIObjectParams = new GUIObjectParams(1, 300);
        Rectangle rectangle = gUIObjectParams.getRect();
        Color color = gUIObjectParams.getForegroundColor();
        Color color2 = gUIObjectParams.getBackgroundColor();
        Font font = gUIObjectParams.getFont();
        String string = gUIObjectParams.getBackgroundImage();
        this.getFrame().setTitle(gUIObjectParams.getLabel());
        ((Component)this.getFrame()).setFont(font);
        this.getFrame().move(rectangle.x, rectangle.y);
        this.getFrame().resize(rectangle.width, rectangle.height);
        this.getFrame().setForeground(color);
        ((Component)this.getFrame()).setBackground(color2);
        if (string != null) {
            this.getFrame().setBackgroundImage(string);
        }
        this.getFrame().show();
        this.SelectButton = new FCButton(1, 301);
        this.SelectButton.setEventCatcher(this);
        this.getFrame().add(this.SelectButton);
        this.MyDirList = new DirNameList(this);
        this.getFrame().add(this.MyDirList);
        this.MyDirList.move(24, this.SelectButton.bounds().y + this.SelectButton.size().height + 24);
        this.MyDirList.resize(this.getFrame().size().width - 16 - 24, this.getFrame().size().height - this.MyDirList.bounds().y - 24);
    }

    public void catchEvent(Component component, Event event) {
        if (component == this.SelectButton && event.id == 1001 && this.MyDirList.getRowSelected() >= 0) {
            int n = this.MyDirList.ItemIndexToServerIndex(this.MyDirList.getRowSelected());
            this.SelectDirEntry(n);
            this.ClosePressed();
        }
    }

    public void peekEvent(Event event) {
        if (this.MyDirList != null && this.SelectButton != null) {
            this.MyDirList.move(24, this.SelectButton.bounds().y + this.SelectButton.size().height + 24);
            this.MyDirList.resize(this.getFrame().size().width - 16 - 24, this.getFrame().size().height - this.MyDirList.bounds().y - 24);
        }
    }

    public void SelectDirEntry(int n) {
        Debug.Print(3, "SelectDirEntry(" + n + ")\n");
        byte[] byArray = new byte[]{-22, -22, 2, 34, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0};
        byArray[8] = (byte)(this.GetObjID() >> 8);
        byArray[9] = (byte)(this.GetObjID() & 0xFF);
        byArray[10] = (byte)(n >> 8);
        byArray[11] = (byte)(n & 0xFF);
        try {
            this.getConnection().SendPacket(byArray);
            return;
        }
        catch (IOException iOException) {
            FCException.handleException(iOException);
            return;
        }
    }

    public void HandleReply(int n, byte[] byArray) {
        Debug.Print(3, "HandleReply ObjID:" + this.GetObjID() + "\n");
        switch (n) {
            case 8: {
                int n2 = FCPConnection.MotorolaShort(byArray, 2);
                int n3 = FCPConnection.MotorolaShort(byArray, 4);
                FCPConnection.MotorolaShort(byArray, 6);
                switch (n2) {
                    case 10: {
                        int n4 = 11;
                        int n5 = FCPConnection.MotorolaShort(byArray, 8);
                        String string = null;
                        try {
                            string = new String(byArray, n4 + 1, FCPConnection.Unsigned(byArray[n4]));
                        }
                        catch (Exception exception) {
                            FCException.handleException(exception);
                        }
                        if (this.GotEOF) {
                            if (this.MyDirList.getRowCount() > 0) {
                                this.MyDirList.clear();
                            }
                            this.GotEOF = false;
                        }
                        if (string.length() <= 0) break;
                        this.MyDirList.NewItem(n3, this.cicnID(n5), string, 2);
                        return;
                    }
                    case 24: {
                        Debug.Print(3, "dEOF\n");
                        this.GotEOF = true;
                        this.MyDirList.repaint();
                        return;
                    }
                    default: {
                        Debug.Print(2, "CDirList unhandled ObjDatatype " + n2 + "\n");
                    }
                }
                return;
            }
            case 12: {
                FCPConnection.MotorolaShort(byArray, 0);
                FCPConnection.MotorolaShort(byArray, 2);
                this.ClosePressed();
                return;
            }
        }
        Debug.Print(2, "Unhandled reply:" + n + "\n");
    }

    private int cicnID(int n) {
        return 9200 + n;
    }
}

