/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

public class FCDialog
extends FCFrame
implements FrameOwner {
    private int numButtons;
    private FCButton[] ButtonArray;
    private int lastButtonClicked;
    private int numEditFields;
    private Label[] EditLabelArray;
    private TextField[] EditFieldArray;
    private int[] EditWidthArray;

    FCDialog() {
        super.setFrameOwner(this);
        this.setBackgroundImage("fcdialog.gif");
        if (FCChat.snd129 != null) {
            FCChat.snd129.play();
        }
    }

    public boolean isClicked() {
        int n = 0;
        while (n < this.numButtons) {
            if (this.ButtonArray[n].isClicked()) {
                this.lastButtonClicked = n;
                return true;
            }
            ++n;
        }
        return false;
    }

    public int buttonClicked() {
        Integer n = new Integer(this.lastButtonClicked);
        return n;
    }

    public void waitForAction() {
        this.repaint();
        while (!this.isClicked()) {
            FCChat.fcp.Run(1);
        }
    }

    public int EditSetNum(int n) {
        this.EditLabelArray = new Label[n];
        this.EditFieldArray = new TextField[n];
        this.EditWidthArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.EditLabelArray[n2] = new Label();
            this.add(this.EditLabelArray[n2]);
            this.EditFieldArray[n2] = new TextField();
            this.EditFieldArray[n2].setEditable(true);
            this.add(this.EditFieldArray[n2]);
            this.EditWidthArray[n2] = 1;
            ++n2;
        }
        this.numEditFields = n;
        this.fixupLayout();
        return this.numEditFields;
    }

    public boolean EditSetLabel(int n, String string) {
        this.EditLabelArray[n].setText(string);
        this.fixupLayout();
        return true;
    }

    public boolean EditSetText(int n, String string) {
        ((TextComponent)this.EditFieldArray[n]).setText(string);
        this.fixupLayout();
        return true;
    }

    public String EditGetText(int n) {
        return this.EditFieldArray[n].getText();
    }

    public boolean EditSetWidth(int n, int n2) {
        this.EditWidthArray[n] = n2;
        this.fixupLayout();
        return true;
    }

    public boolean EditSetEchoChar(int n, char c) {
        this.EditFieldArray[n].setEchoCharacter(c);
        this.fixupLayout();
        return true;
    }

    public int ButtonSetNum(int n) {
        this.ButtonArray = new FCButton[n];
        int n2 = 0;
        while (n2 < n) {
            this.ButtonArray[n2] = new FCButton();
            this.add(this.ButtonArray[n2]);
            ++n2;
        }
        this.numButtons = n;
        this.fixupLayout();
        return this.numButtons;
    }

    public boolean ButtonSetLabel(int n, String string) {
        this.ButtonArray[n].setLabel(string);
        this.fixupLayout();
        return true;
    }

    public FCButton ButtonGet(int n) {
        return this.ButtonArray[n];
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.fixupLayout();
    }

    public void resize(Dimension dimension) {
        super.resize(dimension);
        this.fixupLayout();
    }

    void fixupLayout() {
        this.fixupButtonLayout();
        this.fixupTextLayout();
    }

    private int getMaxEditLabelWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numEditFields) {
            if (this.EditLabelArray[n2].preferredSize().width > n) {
                n = this.EditLabelArray[n2].preferredSize().width;
            }
            ++n2;
        }
        return n;
    }

    private void resizeTextFields() {
        Component component;
        int n = 0;
        while (n < this.numEditFields) {
            component = this.EditLabelArray[n];
            component.resize(this.getMaxEditLabelWidth(), component.preferredSize().height);
            ++n;
        }
        n = 0;
        while (n < this.numEditFields) {
            component = this.EditFieldArray[n];
            component.resize(((TextField)component).preferredSize(this.EditWidthArray[n]));
            ++n;
        }
    }

    private void fixupTextLayout() {
        Component component;
        int n = 64;
        this.resizeTextFields();
        int n2 = 0;
        while (n2 < this.numEditFields) {
            component = this.EditLabelArray[n2];
            component.move(10, 30 * n2 + n);
            component.show();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numEditFields) {
            component = this.EditFieldArray[n2];
            component.move(10 + this.EditLabelArray[n2].size().width, 30 * n2 + n);
            component.show();
            component.enable();
            ++n2;
        }
    }

    private void resizeButtons() {
        int n = 0;
        while (n < this.numButtons) {
            FCButton fCButton = this.ButtonArray[n];
            fCButton.setOptimalSize();
            ++n;
        }
    }

    private int getMaxButtonHeight() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numButtons) {
            if (this.ButtonArray[n2].size().height > n) {
                n = this.ButtonArray[n2].size().height;
            }
            ++n2;
        }
        return n;
    }

    private int getMaxButtonWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numButtons) {
            if (this.ButtonArray[n2].size().width > n) {
                n = this.ButtonArray[n2].size().width;
            }
            ++n2;
        }
        return n;
    }

    private void fixupButtonLayout() {
        int n = 24;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.resizeButtons();
        n2 = this.getMaxButtonWidth();
        n3 = this.getMaxButtonHeight();
        n4 = this.numButtons * n2;
        n5 = (this.size().width - n4) / (this.numButtons + 1);
        int n6 = 0;
        while (n6 < this.numButtons) {
            FCButton fCButton = this.ButtonArray[n6];
            fCButton.move(n5 + n6 * n5 + n6 * n2, this.size().height - n3 - n3 - n);
            fCButton.show();
            fCButton.enable();
            ++n6;
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 202: {
                this.fixupLayout();
                break;
            }
            case 204: {
                this.fixupLayout();
                break;
            }
            case 201: {
                this.ClosePressed();
                break;
            }
            case 205: {
                this.fixupLayout();
                break;
            }
        }
        return super.handleEvent(event);
    }

    public void ClosePressed() {
        this.dispose();
    }
}

