/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;

public class FCFrame
extends Frame {
    private FrameOwner owner;
    private Image backgroundImage;
    private boolean tileBackground = true;
    private String backgroundImageName;
    private FCImageLoader imageLoader;

    FCFrame() {
        this.setLayout(null);
    }

    FCFrame(FrameOwner frameOwner) {
        this.owner = frameOwner;
        this.setLayout(null);
    }

    public void setFrameOwner(FrameOwner frameOwner) {
        this.owner = frameOwner;
    }

    public FrameOwner getFrameOwner() {
        return this.owner;
    }

    public boolean handleEvent(Event event) {
        boolean bl = false;
        switch (event.id) {
            case 202: {
                bl = this.DoWindowExpose(event);
                break;
            }
            case 203: {
                bl = this.DoWindowMinimize(event);
                break;
            }
            case 204: {
                bl = this.DoWindowMaximize(event);
                break;
            }
            case 201: {
                bl = this.DoWindowClose(event);
                break;
            }
            case 205: {
                bl = this.DoWindowMoved(event);
                break;
            }
        }
        bl = super.handleEvent(event);
        this.owner.peekEvent(event);
        return bl;
    }

    public boolean DoWindowExpose(Event event) {
        return false;
    }

    public boolean DoWindowMinimize(Event event) {
        return false;
    }

    public boolean DoWindowMaximize(Event event) {
        return false;
    }

    public boolean DoWindowClose(Event event) {
        this.owner.ClosePressed();
        return true;
    }

    public boolean DoWindowMoved(Event event) {
        return false;
    }

    public void peekEvent(Event event) {
    }

    public void paint(Graphics graphics) {
        if (this.imageLoader != null) {
            this.imageLoader.waitForImage(this.backgroundImage);
            int n = this.backgroundImage.getWidth(this);
            int n2 = this.backgroundImage.getHeight(this);
            Rectangle rectangle = this.bounds();
            if (this.tileBackground) {
                int n3 = 0;
                while (n3 < rectangle.height / n2 + 1) {
                    int n4 = 0;
                    while (n4 < rectangle.width / n + 1) {
                        graphics.drawImage(this.backgroundImage, n4 * n, n3 * n2, n, n2, this);
                        ++n4;
                    }
                    ++n3;
                }
            } else {
                graphics.drawImage(this.backgroundImage, 0, 0, rectangle.width, rectangle.height, this);
            }
        }
        if (this.owner != null && this.owner != this) {
            this.owner.paint(graphics);
        }
    }

    public void setBackgroundImage(String string) {
        try {
            URL uRL = new URL(FCChat.gApplet.getCodeBase(), "img/" + string);
            Debug.Print(2, "(FCFrame) Image URL: " + uRL.toString() + "\n");
            this.backgroundImageName = string;
            this.backgroundImage = FCChat.gApplet.getImage(uRL);
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
        this.imageLoader = new FCImageLoader(this);
        this.imageLoader.loadImage(this.backgroundImage);
    }
}

