/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;

public class FCCharset {
    private static String serverCharsetIndex = "10000";
    private static String serverEncoding = "MacRoman";
    private static String[][] countryToCharsetMap = new String[][]{{"af", "1252"}, {"sq", "1250"}, {"eu", "1252"}, {"bg", "1251"}, {"be", "1251"}, {"ca", "1252"}, {"zh", "936"}, {"zh-CN", "936"}, {"zh-TW", "936"}, {"hr", "1250"}, {"cs", "1250"}, {"da", "1252"}, {"nl", "1252"}, {"nl-BE", "1252"}, {"en", "1252"}, {"en-GB", "1252"}, {"en-US", "1252"}, {"fo", "1250"}, {"fi", "1252"}, {"fr", "1252"}, {"fr-BE", "1252"}, {"fr-CA", "1252"}, {"fr-FR", "1252"}, {"fr-CH", "1252"}, {"gl", "1252"}, {"de", "1252"}, {"de-AU", "1252"}, {"de-DE", "1252"}, {"de-CH", "1252"}, {"el", "1253"}, {"hu", "1250"}, {"is", "1252"}, {"id", "1252"}, {"ga", "1252"}, {"it", "1252"}, {"ja", "932"}, {"ko", "949"}, {"mk", "1253"}, {"no", "1252"}, {"pl", "1250"}, {"pt", "1252"}, {"pt-BR", "1252"}, {"ro", "1250"}, {"ru", "1251"}, {"gd", "1252"}, {"sr", "1250"}, {"sk", "1250"}, {"sl", "1250"}, {"es", "1252"}, {"es-AR", "1252"}, {"es-CO", "1252"}, {"es-MX", "1252"}, {"es-ES", "1252"}, {"sv", "1252"}, {"tr", "1254"}, {"uk", "1252"}, {"", ""}};
    private static String[][] serverToUnicodeMap = new String[][]{{"20000", "Cp1252"}, {"10000", "MacRoman"}, {"1252", "Cp1252"}, {"437", "Cp437"}, {"850", "8859_1"}, {"852", "8859_2"}, {"932", "MS932"}, {"932", "SJIS"}, {"10001", "SJIS"}, {"20001", "EUC_JP"}, {"20002", "ISO2022JP"}, {"10003", "Cp949"}, {"949", "Cp949"}, {"936", "GB2312"}, {"936", "GBK"}, {"936", "EUC_CN"}, {"10002", "EUC_CN"}, {"20004", "ISO2022CN_GB"}, {"1253", "Cp1253"}, {"10006", "MacGreek"}, {"737", "Cp737"}, {"851", "Cp869"}, {"869", "Cp869"}, {"1254", "Cp1254"}, {"10081", "MacTurkish"}, {"857", "Cp857"}, {"1255", "Cp1255"}, {"10005", "MacHebrew"}, {"862", "Cp862"}, {"1256", "Cp1256"}, {"10004", "MacArabic"}, {"864", "Cp864"}, {"1257", "Cp1257"}, {"775", "Cp775"}, {"1251", "Cp1251"}, {"10007", "MacCyrillic"}, {"855", "Cp855"}, {"874", "Cp874"}, {"10021", "MacThai"}, {"1250", "Cp1250"}, {"10029", "MacCentralEurope"}, {"860", "Cp860"}, {"863", "Cp863"}, {"865", "Cp865"}, {"866", "Cp866"}, {"10079", "MacIceland"}, {"861", "Cp861"}, {"20005", "Cp850"}, {"", ""}};

    private static String cc2cs(String string) {
        String string2;
        String string3 = "1252";
        int n = 0;
        while ((string2 = countryToCharsetMap[n][0]).length() > 0) {
            if (string2.equalsIgnoreCase(string)) {
                string3 = countryToCharsetMap[n][1];
                break;
            }
            ++n;
        }
        Debug.Print(3, "cc2cs: " + string + " = " + string3 + "\n");
        return string3;
    }

    public static String getServerCharset() {
        return serverCharsetIndex;
    }

    public static String getServerEncoding() {
        return serverEncoding;
    }

    public static String languageToCharset(String string) {
        return FCCharset.cc2cs(string);
    }

    public static String s2u(String string) {
        String string2;
        String string3 = "Cp1252";
        String string4 = "Test";
        int n = 0;
        while ((string2 = serverToUnicodeMap[n][0]).length() > 0) {
            block4: {
                if (string2.equalsIgnoreCase(string)) {
                    try {
                        byte[] byArray = string4.getBytes(serverToUnicodeMap[n][1]);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        break block4;
                    }
                    string3 = serverToUnicodeMap[n][1];
                    break;
                }
            }
            ++n;
        }
        Debug.Print(3, "s2u: " + string + " = " + string3 + "\n");
        return string3;
    }

    public static void setServerCharset(short s) {
        Debug.Print(3, "setServerCharsetIndex:" + s + "\n");
        serverCharsetIndex = new Integer(s).toString();
        serverEncoding = FCCharset.s2u(serverCharsetIndex);
    }

    public static String u2s(String string) {
        String string2;
        String string3 = "10000";
        int n = 0;
        while ((string2 = serverToUnicodeMap[n][1]).length() > 0) {
            if (string2.equalsIgnoreCase(string)) {
                string3 = serverToUnicodeMap[n][0];
                break;
            }
            ++n;
        }
        Debug.Print(3, "u2s: " + string + " = " + string3 + "\n");
        return string3;
    }
}

