/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;

public class FCScrollPane
extends FCPanel {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private static int sbDisplayPolicy = 0;
    private static FCScrollbar sbH = null;
    private static FCScrollbar sbV = null;

    public FCScrollPane() {
        this(0);
    }

    public FCScrollPane(int n) {
        sbDisplayPolicy = n;
        sbH = new FCScrollbar(this, 0);
        sbV = new FCScrollbar(this, 1);
        sbH.setVisible(false);
        sbV.setVisible(false);
        this.setLayout(null);
        this.add(sbH);
        this.add(sbV);
    }

    public void catchEvent(Component component, AdjustmentEvent adjustmentEvent) {
        if (component == sbH || component == sbV) {
            this.setScrollPosition(sbH.getValue(), sbV.getValue());
        }
    }

    protected int documentHLineIncrement() {
        return 1;
    }

    protected int documentHPageIncrement() {
        return 10;
    }

    protected int documentHeight() {
        return 0;
    }

    protected int documentVLineIncrement() {
        return 1;
    }

    protected int documentVPageIncrement() {
        return 10;
    }

    protected int documentWidth() {
        return 0;
    }

    private void drawScrollbars() {
        if (FCScrollPane.sbH.getSize().height <= 0) {
            sbH.setSize(FCScrollPane.sbH.getSize().width, 16);
        }
        if (FCScrollPane.sbV.getSize().height <= 0) {
            sbV.setSize(16, FCScrollPane.sbH.getSize().height);
        }
        switch (sbDisplayPolicy) {
            case 1: {
                sbH.setLocation(0, this.getSize().height - FCScrollPane.sbH.getSize().height);
                sbH.setSize(this.getSize().width - FCScrollPane.sbV.getSize().width, FCScrollPane.sbH.getSize().height);
                if (!sbH.isVisible()) {
                    sbH.setVisible(true);
                }
                sbV.setLocation(this.getSize().width - FCScrollPane.sbV.getSize().width, 0);
                sbV.setSize(FCScrollPane.sbV.getSize().width, this.getSize().height - FCScrollPane.sbH.getSize().height);
                if (sbV.isVisible()) break;
                sbV.setVisible(true);
                break;
            }
            case 0: {
                if (this.documentWidth() > this.getSize().width) {
                    sbH.setLocation(0, this.getSize().height - FCScrollPane.sbH.getSize().height);
                    if (this.documentHeight() > this.getSize().height) {
                        sbH.setSize(this.getSize().width - FCScrollPane.sbV.getSize().width, FCScrollPane.sbH.getSize().height);
                    } else {
                        sbH.setSize(this.getSize().width, FCScrollPane.sbH.getSize().height);
                    }
                    sbH.setVisible(true);
                } else {
                    sbH.setVisible(false);
                }
                if (this.documentHeight() > this.getSize().height) {
                    sbV.setLocation(this.getSize().width - FCScrollPane.sbV.getSize().width, 0);
                    if (this.documentWidth() > this.getSize().width) {
                        sbV.setSize(FCScrollPane.sbV.getSize().width, this.getSize().height - FCScrollPane.sbH.getSize().height);
                    } else {
                        sbV.setSize(FCScrollPane.sbV.getSize().width, this.getSize().height);
                    }
                    sbV.setVisible(true);
                    break;
                }
                sbV.setVisible(false);
                break;
            }
            default: {
                if (sbH.isVisible()) {
                    sbH.setVisible(false);
                }
                if (!sbV.isVisible()) break;
                sbV.setVisible(false);
            }
        }
        if (sbH.isVisible()) {
            sbH.setUnitIncrement(this.documentHLineIncrement());
            sbH.setBlockIncrement(this.documentHPageIncrement());
            sbH.setValues(sbH.getValue(), this.documentWidth() - this.getViewportSize().width, 0, this.documentWidth());
        }
        if (sbV.isVisible()) {
            sbV.setUnitIncrement(this.documentVLineIncrement());
            sbV.setBlockIncrement(this.documentVPageIncrement());
            sbV.setValues(sbV.getValue(), this.documentHeight() - this.getViewportSize().height, 0, this.documentHeight());
        }
    }

    public FCScrollbar getHAdjustable() {
        return sbH;
    }

    public int getHScrollbarHeight() {
        return FCScrollPane.sbH.getSize().height;
    }

    public Point getScrollPosition() {
        Point point = new Point(sbH.getValue(), sbV.getValue());
        return point;
    }

    public int getScrollbarDisplayPolicy() {
        return sbDisplayPolicy;
    }

    public FCScrollbar getVAdjustable() {
        return sbV;
    }

    public int getVScrollbarWidth() {
        return FCScrollPane.sbV.getSize().width;
    }

    public Dimension getViewportSize() {
        int n = 0;
        int n2 = 0;
        if (sbV.isVisible()) {
            n = FCScrollPane.sbV.getSize().width;
        }
        if (sbH.isVisible()) {
            n2 = FCScrollPane.sbH.getSize().height;
        }
        Dimension dimension = new Dimension(this.getSize().width - n, this.getSize().height - n2);
        return dimension;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawScrollbars();
    }

    public void setScrollPosition(int n, int n2) {
        if (sbH.getValue() != n) {
            sbH.setValues(n, this.documentWidth() - this.getViewportSize().width, 0, this.documentWidth());
        }
        if (sbV.getValue() != n2) {
            sbV.setValues(n2, this.documentHeight() - this.getViewportSize().height, 0, this.documentHeight());
        }
    }

    public void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (n != this.getSize().width || n2 != this.getSize().height) {
            this.drawScrollbars();
        }
    }
}

