/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;

public class FCServerObject
implements FrameOwner {
    private int ObjID;
    private FCPConnection MyConnection = null;
    private FCFrame MyFrame = null;

    public FCServerObject() {
    }

    public FCServerObject(FCPConnection fCPConnection, int n) {
        this.ObjID = n;
        this.MyConnection = fCPConnection;
    }

    public FCServerObject(FCPConnection fCPConnection, int n, boolean bl) {
        this.ObjID = n;
        this.MyConnection = fCPConnection;
        if (bl) {
            this.MyFrame = new FCFrame(this);
        }
    }

    public void Close() throws IOException {
        this.MyConnection.CloseObject(this.ObjID);
    }

    public void ClosePressed() {
        try {
            this.getFrame().dispose();
            this.Close();
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
    }

    public int GetObjID() {
        return this.ObjID;
    }

    public void HandleReply(int n, byte[] byArray) {
        Debug.Print(2, "FCServerObject: unhandled reply: " + n + "\n");
    }

    public void OpenIndex(int n) throws IOException {
        this.MyConnection.OpenObject(this.ObjID, n);
    }

    public Rectangle bounds() {
        return this.MyFrame.getBounds();
    }

    public void catchEvent(Component component, Event event) {
        Debug.Print(4, "Unhandled event: " + event.toString() + "\n");
    }

    public FCPConnection getConnection() {
        return this.MyConnection;
    }

    public FCFrame getFrame() {
        return this.MyFrame;
    }

    public String getTitle() {
        return this.MyFrame.getTitle();
    }

    public void paint(Graphics graphics) {
    }

    public void peekEvent(Event event) {
    }

    public void repaint() {
        this.MyFrame.repaint();
    }

    public void resize(int n, int n2) {
        ((Component)this.MyFrame).setSize(n, n2);
    }

    public void resize(Dimension dimension) {
        ((Component)this.MyFrame).setSize(dimension);
    }

    public void setBackgroundImage(String string) {
        this.MyFrame.setBackgroundImage(string);
    }

    public void setTitle(String string) {
        this.MyFrame.setTitle(string);
    }

    public void setVisible(boolean bl) {
        ((Component)this.MyFrame).setVisible(bl);
    }
}

