/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class FCTable
extends FCScrollPane {
    private int[] rowSelected = new int[1];
    private Image[] icon = null;
    private String[] text = null;
    private int[] attr = null;
    private int rowCount = 0;
    private int rowHeight = 18;
    private int topRow = 0;
    private int textCol = 16;
    private FCScrollbar hAdjustable;
    private FCScrollbar vAdjustable;
    private FCImageLoader imageLoader = null;
    private boolean multiON = false;
    private boolean isFocus = false;

    public FCTable() {
        this.rowSelected[0] = -1;
        this.rowHeight = 18;
        this.topRow = 0;
        this.hAdjustable = this.getHAdjustable();
        this.vAdjustable = this.getVAdjustable();
        this.addMouseListener(new MouseL());
        this.addKeyListener(new KeyL());
        this.addFocusListener(new FocusL());
        this.setBackground(new Color(255, 255, 255));
        this.setForeground(new Color(0, 0, 0));
        this.setEnabled(true);
    }

    static /* synthetic */ boolean access$3(FCTable fCTable) {
        return fCTable.isFocus;
    }

    public int addItem(int n, String string, int n2) {
        Image[] imageArray = new Image[this.rowCount + 1];
        String[] stringArray = new String[this.rowCount + 1];
        int[] nArray = new int[this.rowCount + 1];
        int n3 = 0;
        while (n3 < this.rowCount) {
            imageArray[n3] = this.icon[n3];
            stringArray[n3] = this.text[n3];
            nArray[n3] = this.attr[n3];
            ++n3;
        }
        if (FCChat.getCICN(n) == null) {
            Debug.Print(1, "There is no icon relative to ResID:" + n + "\n");
            imageArray[this.rowCount] = FCChat.getCICN(9200);
        } else {
            imageArray[this.rowCount] = FCChat.getCICN(n);
        }
        stringArray[this.rowCount] = string;
        nArray[this.rowCount] = n2;
        this.icon = imageArray;
        this.text = stringArray;
        this.attr = nArray;
        if (this.rowCount++ == 0) {
            this.rowHeight = this.getFontMetrics(this.getFont()).getHeight();
            this.setScrollPosition(0, 0);
        }
        return this.rowCount - 1;
    }

    public int bottomVisibleRow() {
        int n = this.getViewportSize().height;
        n = n <= this.rowHeight ? 0 : (n /= this.rowHeight);
        int n2 = this.topVisibleRow() + n;
        if (n2 > this.rowCount) {
            n2 = this.rowCount;
        }
        return n2;
    }

    public void clear() {
        this.rowSelected[0] = -1;
        this.icon = null;
        this.text = null;
        this.attr = null;
        this.rowCount = 0;
        this.topRow = 0;
        this.repaint();
    }

    public int countSelected() {
        int n = 0;
        if (this.multiON) {
            n = this.rowSelected.length;
        } else if (this.rowSelected[0] >= 0) {
            n = 1;
        }
        return n;
    }

    public void deselectAll() {
        if (this.multiON) {
            int[] nArray = this.getSelectedRows();
            int n = this.countSelected();
            int n2 = 0;
            while (n2 < n) {
                this.deselectRow(nArray[n2]);
                ++n2;
            }
        } else {
            this.deselectRow(this.getRowSelected());
        }
    }

    public void deselectRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            if (this.isSelected(n)) {
                if (this.multiON && this.countSelected() > 1) {
                    int[] nArray = new int[this.countSelected() - 1];
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < this.countSelected()) {
                        if (this.rowSelected[n3] != n) {
                            nArray[n2++] = this.rowSelected[n3];
                        }
                        ++n3;
                    }
                    this.rowSelected = nArray;
                } else if (this.rowSelected[0] == n) {
                    this.rowSelected[0] = -1;
                }
            }
            this.drawRow(this.getGraphics(), n, 0, this.getRowY(n));
        }
        this.drawFocusRect(this.getGraphics());
    }

    protected int documentHLineIncrement() {
        return 1;
    }

    protected int documentHPageIncrement() {
        return 12;
    }

    protected int documentHeight() {
        return this.getRowCount() * this.rowHeight;
    }

    protected int documentVLineIncerement() {
        return this.rowHeight;
    }

    protected int documentVPageIncrement() {
        return this.rowHeight;
    }

    protected int documentWidth() {
        return 100;
    }

    protected void doubleClick(Event event, int n, int n2) {
    }

    private void drawFocusRect(Graphics graphics) {
        this.eraseFocusRect(graphics);
        graphics.setColor(new Color(0, 0, 0));
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        if (this.isFocus) {
            graphics.drawRect(1, 1, this.getSize().width - 3, this.getSize().height - 3);
        }
    }

    private void drawRow(Graphics graphics, int n, int n2, int n3) {
        if (n >= 0 && n < this.getRowCount() && n >= this.topVisibleRow() && n <= this.bottomVisibleRow()) {
            this.eraseRow(graphics, n, n2, n3);
            this.paintRow(graphics, n, n2, n3);
        }
    }

    private void eraseFocusRect(Graphics graphics) {
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawRect(1, 1, this.getSize().width - 3, this.getSize().height - 3);
    }

    private void eraseRow(Graphics graphics, int n, int n2, int n3) {
        if (this.isSelected(n)) {
            graphics.setColor(new Color(0, 0, 128));
        } else {
            graphics.setColor(new Color(255, 255, 255));
        }
        graphics.fillRect(n2, n3, this.getViewportSize().width, this.rowHeight);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getRowSelected() {
        return this.rowSelected[0];
    }

    public int getRowY(int n) {
        return (n - this.topVisibleRow()) * this.rowHeight;
    }

    public int[] getSelectedRows() {
        return this.rowSelected;
    }

    public String getTextItem(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            return this.text[n];
        }
        return "";
    }

    public boolean isMultiSelect() {
        return this.multiON;
    }

    public boolean isSelected(int n) {
        boolean bl = false;
        if (!this.multiON && this.rowSelected[0] == n && n >= 0) {
            bl = true;
        }
        return bl;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.redraw(graphics);
    }

    private void paintRow(Graphics graphics, int n, int n2, int n3) {
        Font font = new Font(this.getFont().getName(), this.attr[n], this.getFont().getSize());
        graphics.setFont(font);
        if (this.icon != null) {
            Image image;
            if (this.isSelected(n)) {
                graphics.setColor(new Color(255, 255, 255));
                graphics.fillRect(n2, n3, this.textCol, this.rowHeight);
            }
            if ((image = this.icon[n]) != null) {
                this.imageLoader = new FCImageLoader(this);
                this.imageLoader.loadImage(image);
                this.imageLoader.waitForImage(image);
                graphics.drawImage(image, n2 + 2, n3 + 2, null);
            }
        }
        if (this.text != null) {
            if (this.isSelected(n)) {
                graphics.setColor(new Color(255, 255, 255));
            } else {
                graphics.setColor(new Color(0, 0, 0));
            }
            graphics.drawString(this.text[n], n2 + this.textCol, n3 + graphics.getFontMetrics(graphics.getFont()).getAscent() + 2);
        }
    }

    private void redraw(Graphics graphics) {
        int n = this.bottomVisibleRow();
        int n2 = this.topVisibleRow();
        while (n2 < n) {
            int n3 = this.getRowY(n2);
            int n4 = 0;
            this.drawRow(graphics, n2, n4, n3);
            ++n2;
        }
        this.drawFocusRect(graphics);
    }

    public void selectRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            if (!this.isSelected(n)) {
                if (this.multiON && n >= 0) {
                    if (this.countSelected() == 0) {
                        this.rowSelected[0] = n;
                    } else {
                        int[] nArray = new int[this.countSelected() + 1];
                        int n2 = 0;
                        while (n2 < this.countSelected()) {
                            nArray[n2] = this.rowSelected[n2];
                            ++n2;
                        }
                        nArray[this.countSelected()] = n;
                        this.rowSelected = nArray;
                    }
                } else if (!this.multiON) {
                    this.deselectRow(this.rowSelected[0]);
                    this.rowSelected[0] = n;
                }
            }
            this.drawRow(this.getGraphics(), n, 0, this.getRowY(n));
        }
        this.drawFocusRect(this.getGraphics());
    }

    public void setMulti(boolean bl) {
        this.multiON = bl;
    }

    public void setScrollPosition(int n, int n2) {
        int n3 = n2 / this.rowHeight;
        if (n3 != this.topRow) {
            this.topRow = n3;
            super.setScrollPosition(n, n2);
            this.repaint();
        }
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (n != this.getSize().width || n2 != this.getSize().height) {
            this.setScrollPosition(0, 0);
        }
    }

    public int topVisibleRow() {
        return this.topRow;
    }

    class KeyL
    extends KeyAdapter {
        KeyL() {
        }

        public void KeyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    int n = FCTable.this.topRow;
                    int n2 = FCTable.this.getRowSelected();
                    FCTable.this.selectRow(n2 - 1);
                    if (FCTable.this.getRowSelected() < 0) break;
                    while (FCTable.this.getRowSelected() < FCTable.this.topVisibleRow() && FCTable.this.topVisibleRow() >= 0) {
                        FCTable fCTable = FCTable.this;
                        fCTable.topRow = fCTable.topRow - 1;
                    }
                    if (n == FCTable.this.topRow) break;
                    FCTable.this.repaint();
                    break;
                }
                case 40: {
                    int n = FCTable.this.topRow;
                    int n3 = FCTable.this.getRowSelected();
                    FCTable.this.selectRow(n3 + 1);
                    if (FCTable.this.getRowSelected() < 0) break;
                    while (FCTable.this.getRowSelected() >= FCTable.this.bottomVisibleRow()) {
                        FCTable fCTable = FCTable.this;
                        fCTable.topRow = fCTable.topRow + 1;
                    }
                    if (n == FCTable.this.topRow) break;
                    FCTable.this.repaint();
                    break;
                }
            }
        }

        public void KeyTyped(KeyEvent keyEvent) {
            keyEvent.getKeyChar();
        }
    }

    class MouseL
    extends MouseAdapter {
        MouseL() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            FCTable.this.requestFocus();
            if ((mouseEvent.getModifiers() | 1) == 0 || mouseEvent.getClickCount() > 1) {
                FCTable.this.deselectAll();
            }
            FCTable.this.selectRow(FCTable.this.topVisibleRow() + mouseEvent.getY() / FCTable.this.rowHeight);
            mouseEvent.getClickCount();
        }
    }

    class FocusL
    implements FocusListener {
        FocusL() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Graphics graphics = FCTable.this.getGraphics();
            FCTable.this.isFocus = true;
            if (FCTable.this.getRowSelected() >= 0) {
                int n = FCTable.this.getRowSelected();
                int n2 = FCTable.this.getRowY(n);
                int n3 = 0;
                FCTable.this.drawRow(graphics, n, n3, n2);
            }
            FCTable.this.drawFocusRect(graphics);
        }

        public void focusLost(FocusEvent focusEvent) {
            Graphics graphics = FCTable.this.getGraphics();
            if (graphics != null) {
                FCTable.this.isFocus = false;
                FCTable.this.drawFocusRect(graphics);
            }
        }
    }
}

