/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class FCDialog
extends FCFrame
implements FrameOwner {
    private int numButtons;
    private FCButton[] ButtonArray;
    private int lastButtonClicked = 0;
    private int numEditFields;
    private Label[] EditLabelArray;
    private TextField[] EditFieldArray;
    private int[] EditWidthArray;
    private boolean needClose = false;
    private boolean needButtonClick = false;

    FCDialog() {
        super.setFrameOwner(this);
        this.setBackgroundImage("fcdialog.gif");
        this.setTileBackground(true);
        if (FCChat.snd129 != null) {
            FCChat.snd129.play();
        }
        this.addWindowListener(new WL());
    }

    public FCButton ButtonGet(int n) {
        return this.ButtonArray[n];
    }

    public boolean ButtonSetLabel(int n, String string) {
        this.ButtonArray[n].setLabel(string);
        this.fixupLayout();
        return true;
    }

    public int ButtonSetNum(int n) {
        this.ButtonArray = new FCButton[n];
        int n2 = 0;
        while (n2 < n) {
            this.ButtonArray[n2] = new FCButton();
            this.add(this.ButtonArray[n2]);
            ++n2;
        }
        this.numButtons = n;
        this.fixupLayout();
        return this.numButtons;
    }

    public void ClosePressed() {
        if (!this.needButtonClick) {
            this.dispose();
        } else {
            this.needClose = true;
        }
    }

    public String EditGetText(int n) {
        return this.EditFieldArray[n].getText();
    }

    public boolean EditSetEchoChar(int n, char c) {
        this.EditFieldArray[n].setEchoChar(c);
        this.fixupLayout();
        return true;
    }

    public boolean EditSetLabel(int n, String string) {
        this.EditLabelArray[n].setText(string);
        this.fixupLayout();
        return true;
    }

    public int EditSetNum(int n) {
        this.EditLabelArray = new Label[n];
        this.EditFieldArray = new TextField[n];
        this.EditWidthArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.EditLabelArray[n2] = new Label();
            this.add(this.EditLabelArray[n2]);
            this.EditFieldArray[n2] = new TextField();
            this.EditFieldArray[n2].setEditable(true);
            this.add(this.EditFieldArray[n2]);
            this.EditWidthArray[n2] = 1;
            ++n2;
        }
        this.numEditFields = n;
        this.fixupLayout();
        return this.numEditFields;
    }

    public boolean EditSetText(int n, String string) {
        this.EditFieldArray[n].setText(string);
        this.fixupLayout();
        return true;
    }

    public boolean EditSetWidth(int n, int n2) {
        this.EditWidthArray[n] = n2;
        this.fixupLayout();
        return true;
    }

    public int buttonClicked() {
        Integer n = new Integer(this.lastButtonClicked);
        return n;
    }

    private void fixupButtonLayout() {
        int n = 24;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.resizeButtons();
        n2 = this.getMaxButtonWidth();
        n3 = this.getMaxButtonHeight();
        n4 = this.numButtons * n2;
        n5 = (this.getSize().width - n4) / (this.numButtons + 1);
        int n6 = 0;
        while (n6 < this.numButtons) {
            FCButton fCButton = this.ButtonArray[n6];
            fCButton.setLocation(n5 + n6 * n5 + n6 * n2, this.getSize().height - n3 - n);
            fCButton.setVisible(true);
            fCButton.setEnabled(true);
            ++n6;
        }
    }

    void fixupLayout() {
        this.fixupButtonLayout();
        this.fixupTextLayout();
    }

    private void fixupTextLayout() {
        Component component;
        int n = 64;
        this.resizeTextFields();
        int n2 = 0;
        while (n2 < this.numEditFields) {
            component = this.EditLabelArray[n2];
            component.setLocation(10, 30 * n2 + n);
            component.setVisible(true);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numEditFields) {
            component = this.EditFieldArray[n2];
            component.setLocation(10 + this.EditLabelArray[n2].getSize().width, 30 * n2 + n);
            component.setVisible(true);
            component.setEnabled(true);
            ++n2;
        }
    }

    private int getMaxButtonHeight() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numButtons) {
            if (this.ButtonArray[n2].getSize().height > n) {
                n = this.ButtonArray[n2].getSize().height;
            }
            ++n2;
        }
        return n;
    }

    private int getMaxButtonWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numButtons) {
            if (this.ButtonArray[n2].getSize().width > n) {
                n = this.ButtonArray[n2].getSize().width;
            }
            ++n2;
        }
        return n;
    }

    private int getMaxEditLabelWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numEditFields) {
            if (this.EditLabelArray[n2].getPreferredSize().width > n) {
                n = this.EditLabelArray[n2].getPreferredSize().width;
            }
            ++n2;
        }
        return n;
    }

    public boolean isClicked() {
        int n = 0;
        while (n < this.numButtons) {
            if (this.ButtonArray[n].isClicked()) {
                this.lastButtonClicked = n;
                return true;
            }
            ++n;
        }
        return false;
    }

    private void resizeButtons() {
        int n = 0;
        while (n < this.numButtons) {
            FCButton fCButton = this.ButtonArray[n];
            fCButton.setOptimalSize();
            ++n;
        }
    }

    private void resizeTextFields() {
        Component component;
        int n = this.getMaxEditLabelWidth();
        int n2 = 0;
        while (n2 < this.numEditFields) {
            component = this.EditLabelArray[n2];
            component.setSize(n, component.getPreferredSize().height);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numEditFields) {
            component = this.EditFieldArray[n2];
            component.setSize(((TextField)component).getPreferredSize(this.EditWidthArray[n2]));
            ++n2;
        }
    }

    public void setNeedButtonClick(boolean bl) {
        this.needButtonClick = bl;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.fixupLayout();
    }

    public void setSsize(int n, int n2) {
        super.setSize(n, n2);
        this.fixupLayout();
    }

    public void waitForAction() {
        this.repaint();
        while (!this.needClose && !this.isClicked()) {
            FCChat.fcp.Run(1);
        }
        this.dispose();
    }

    class WL
    extends WindowAdapter {
        WL() {
        }

        public void windowActive(WindowEvent windowEvent) {
            FCDialog.this.fixupLayout();
        }

        public void windowClosing(WindowEvent windowEvent) {
            FCDialog.this.ClosePressed();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            FCDialog.this.fixupLayout();
        }
    }
}

