/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;

public class FCPConnection {
    private static final short AUTHENTICATEOBJID = -6;
    private static final int MAXINNAME = 41;
    Socket fcskt = null;
    InputStream is = null;
    OutputStream os = null;
    Hashtable FCObjTable = new Hashtable();
    int XmitSeq = 0;
    public String UserName = "";
    public String UserPassword = "";
    public String UserMD5Challenge = "";
    public String UserMD5Digest = "";
    public String UserURL = "";
    public int UserPort = 510;
    FCUtil Util = new FCUtil();
    private boolean IsLoggedIn = false;
    private boolean md5_login = false;
    private String DigestStr;
    private String ChallengeStr;
    int HdrBytesRead = 0;
    int PktDataSize = 0;
    byte[] hdr = new byte[8];
    byte[] PktData = null;

    private String CRAM_MD5_Compute(String string, String string2) {
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[65];
        byte[] byArray4 = new byte[65];
        int n = string.length();
        int n2 = string2.length();
        this.Util.memcpy(byArray, 0, string.getBytes(), 0, n);
        this.Util.memcpy(byArray3, 0, byArray, 0, n);
        this.Util.memcpy(byArray4, 0, byArray, 0, n);
        int n3 = 0;
        while (n3 < 64) {
            int n4 = n3;
            byArray3[n4] = (byte)(byArray3[n4] ^ 0x36);
            int n5 = n3++;
            byArray4[n5] = (byte)(byArray4[n5] ^ 0x5C);
        }
        CMD5 cMD5 = new CMD5();
        cMD5.Update(byArray3, 64);
        cMD5.Update(string2.getBytes(), n2);
        cMD5.Final();
        this.Util.memcpy(byArray2, 0, cMD5.Digest(), 0, 16);
        CMD5 cMD52 = new CMD5();
        cMD52.Update(byArray4, 64);
        cMD52.Update(byArray2, 16);
        String string3 = new String(cMD52.Final(), 0, 32);
        return string3;
    }

    int CalcCS4(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        int n3 = n / 4;
        int n4 = 0;
        while (n3 > 0) {
            n2 += FCPConnection.MotorolaLong(byArray, n4);
            --n3;
            n4 += 4;
        }
        if (n4 < n) {
            n2 += FCPConnection.Unsigned(byArray[n4++]) << 24;
        }
        if (n4 < n) {
            n2 += FCPConnection.Unsigned(byArray[n4++]) << 16;
        }
        if (n4 < n) {
            n2 += FCPConnection.Unsigned(byArray[n4++]) << 8;
        }
        return (n2 >> 16) + n2 & 0xFFFF;
    }

    public void CloseObject(int n) throws IOException {
        Debug.Print(3, "CloseObject ObjID:" + n + "\n");
        byte[] byArray = new byte[12];
        byArray[0] = -22;
        byArray[1] = -22;
        byArray[2] = 2;
        byArray[3] = 12;
        byArray[7] = 4;
        byte[] byArray2 = byArray;
        byArray2[8] = (byte)(n >> 8);
        byArray2[9] = (byte)(n & 0xFF);
        byArray2[10] = 0;
        byArray2[11] = 0;
        this.SendPacket(byArray2);
        this.FCObjTable.remove(new Integer(n));
    }

    public boolean Connect(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        try {
            Object[] objectArray;
            if (string2.length() > 0) {
                Debug.Print(2, "Connect using ");
                this.UserName = string2.trim();
                if (this.UserName.length() > 15) {
                    this.UserName = this.UserName.substring(0, 14);
                }
                if (string4.length() > 0 && string5.length() > 0) {
                    Debug.Print(2, "MD5 ");
                    this.md5_login = true;
                    this.UserMD5Challenge = string4;
                    this.UserMD5Digest = string5;
                } else {
                    Debug.Print(2, "Password ");
                    this.md5_login = false;
                    BASE64Decoder bASE64Decoder = new BASE64Decoder();
                    try {
                        objectArray = bASE64Decoder.decodeBuffer(string3);
                        this.UserPassword = new String((byte[])objectArray, 0, objectArray.length);
                    }
                    catch (Exception exception) {
                        FCException.handleException(exception);
                    }
                    if (this.UserPassword.length() > 14) {
                        this.UserPassword = this.UserPassword.substring(0, 13);
                    }
                }
                Debug.Print(2, " Authentication.\n");
            }
            objectArray = InetAddress.getAllByName(string);
            Debug.Print(0, "server has " + objectArray.length + " addresses" + "\n");
            int n = 0;
            while (n < objectArray.length) {
                Debug.Print(0, "address " + n + " is " + objectArray[n].getHostAddress() + "\n");
                ++n;
            }
            this.UserURL = string6;
            try {
                if (string7.length() > 0) {
                    this.UserPort = new Integer(string7);
                }
            }
            catch (Exception exception) {
                FCException.handleException(exception);
            }
            Debug.Print(2, "Connecting to Host " + string + " on port " + this.UserPort + "\n");
            Socket socket = new Socket(objectArray[0], this.UserPort);
            Debug.Print(2, "Socket opened.\n");
            this.is = socket.getInputStream();
            this.os = socket.getOutputStream();
            if (this.is == null || this.os == null) {
                Debug.Print(2, "OutputStream (os) is " + (this.os != null) + " InputStream (is) is " + (this.is != null) + "\n");
            }
            byte[] byArray = new byte[28];
            byArray[0] = -22;
            byArray[1] = -22;
            byArray[3] = 51;
            byArray[4] = -79;
            byArray[5] = 91;
            byArray[7] = 20;
            byArray[8] = -127;
            byArray[9] = 103;
            byArray[10] = 91;
            byArray[11] = 73;
            byArray[12] = 6;
            byArray[13] = 80;
            byArray[14] = 87;
            byArray[15] = -44;
            byArray[16] = 104;
            byArray[17] = 88;
            byArray[18] = -25;
            byArray[19] = -65;
            byArray[20] = -117;
            byArray[21] = 123;
            byArray[22] = -34;
            byArray[23] = -81;
            byArray[24] = -21;
            byArray[25] = 93;
            byArray[26] = -27;
            byArray[27] = -75;
            byte[] byArray2 = byArray;
            this.SendPacket(byArray2);
            Debug.Print(2, "Connection Request  sent\n");
            return true;
        }
        catch (Exception exception) {
            FCException.handleException(exception);
            return false;
        }
    }

    public void Disconnect() {
        Debug.Print(2, "Disconnect()");
        try {
            this.Logout();
            this.is.close();
            this.os.close();
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
        this.is = null;
        this.os = null;
    }

    public void DoDirectory(boolean bl, FCServerObject fCServerObject, String string, int n, int n2, int n3) {
        byte[] byArray = new byte[19];
        byArray[0] = -22;
        byArray[1] = -22;
        byArray[2] = 2;
        byArray[3] = 59;
        byArray[7] = 11;
        byte[] byArray2 = byArray;
        Debug.Print(3, "DoDirectory( index=" + n + " ObjID=" + n3 + " LinkToObj.ObjID=" + fCServerObject.GetObjID() + "\n");
        byArray2[8] = (byte)(fCServerObject.GetObjID() >> 8);
        byArray2[9] = (byte)(fCServerObject.GetObjID() & 0xFF);
        byArray2[12] = (byte)(n >> 8);
        byArray2[13] = (byte)(n & 0xFF);
        try {
            this.SendPacket(byArray2);
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
    }

    public void HandleReply(byte by, byte[] byArray) {
        Debug.Print(3, "FCPConnection::HandleReply Command :" + by + "\n");
        try {
            switch (by) {
                case 51: {
                    this.SendLoginPacket();
                    break;
                }
                case 4: {
                    Debug.Print(3, "Login Reply...\n");
                    short s = FCPConnection.MotorolaShort(byArray, 0);
                    if (s != 0) {
                        this.IsLoggedIn = false;
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(s);
                        fCErrorDialog.waitForAction();
                    } else {
                        short s2 = FCPConnection.MotorolaShort(byArray, 32);
                        Debug.Print(2, "server charset = " + s2 + "\n");
                        FCCharset.setServerCharset(s2);
                        this.IsLoggedIn = true;
                        if (this.UserURL.length() == 0) {
                            Debug.Print(2, "send OpenObject request ObjId=7, Index=0\n");
                            this.OpenObject(7, 0);
                        } else {
                            Debug.Print(4, "OpenURL(" + this.UserURL + ")\n");
                            this.OpenURL(this.UserURL, 0);
                        }
                    }
                    break;
                }
                case 5: {
                    Debug.Print(3, "Logout Reply...\n");
                    this.IsLoggedIn = false;
                    break;
                }
                case 62: {
                    Debug.Print(3, "cObjOpenDup\n");
                    break;
                }
                case 7: {
                    Debug.Print(3, "cObjOpen...\n");
                    Debug.PrintHexBytes(3, byArray);
                    short s = FCPConnection.MotorolaShort(byArray, 0);
                    if (s != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(s);
                        fCErrorDialog.waitForAction();
                    } else {
                        int n = FCPConnection.Unsigned(byArray[2]);
                        short s3 = FCPConnection.MotorolaShort(byArray, 4);
                        short s4 = FCPConnection.MotorolaShort(byArray, 6);
                        short s5 = FCPConnection.MotorolaShort(byArray, 34);
                        Debug.Print(5, "ObjOpenReply (cObjOpen) rc:" + s + " ObjType:" + n + " ObjID:" + s3 + " ReqID:" + s4 + " Chatset:" + s5 + "\n");
                        FCServerObject fCServerObject = this.NewByObjType(n, s3, s5);
                        this.FCObjTable.put(new Integer(s3), fCServerObject);
                    }
                    break;
                }
                case 68: {
                    Debug.Print(3, "cObjOpenQuery...\n");
                    Debug.PrintHexBytes(3, byArray);
                    short s = FCPConnection.MotorolaShort(byArray, 0);
                    if (s != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(s);
                        fCErrorDialog.waitForAction();
                    } else {
                        int n = FCPConnection.Unsigned(byArray[10]);
                        short s6 = FCPConnection.MotorolaShort(byArray, 12);
                        short s7 = FCPConnection.MotorolaShort(byArray, 14);
                        short s8 = FCPConnection.MotorolaShort(byArray, 42);
                        FCServerObject fCServerObject = this.NewByObjType(n, s6, s8);
                        this.FCObjTable.put(new Integer(s6), fCServerObject);
                    }
                    break;
                }
                case 9: {
                    short s = FCPConnection.MotorolaShort(byArray, 2);
                    Debug.Print(3, "cObjUpdate ObjID=" + s + "\n");
                    FCServerObject fCServerObject = (FCServerObject)this.FCObjTable.get(new Integer(s));
                    if (fCServerObject != null) {
                        fCServerObject.HandleReply(by, byArray);
                    } else if (s == -6) {
                        Debug.Print(3, "Got AUTHENTICATEOBJID\n");
                    } else {
                        Debug.Print(2, "ObjID:" + s + " not found \n");
                    }
                    break;
                }
                case 8: {
                    short s = FCPConnection.MotorolaShort(byArray, 0);
                    short s9 = FCPConnection.MotorolaShort(byArray, 2);
                    Debug.Print(3, "cObjData ObjID=" + s + "\n");
                    Debug.Print(3, "cObjData ObjDataType=" + s9 + "\n");
                    FCServerObject fCServerObject = (FCServerObject)this.FCObjTable.get(new Integer(s));
                    if (fCServerObject != null) {
                        fCServerObject.HandleReply(by, byArray);
                    } else {
                        Debug.Print(2, "ObjID:" + s + " not found \n");
                    }
                    break;
                }
                case 59: {
                    short s = FCPConnection.MotorolaShort(byArray, 2);
                    int n = 7;
                    short s10 = FCPConnection.MotorolaShort(byArray, 6);
                    FCServerObject fCServerObject = this.NewByObjType(n, s, (short)0);
                    this.FCObjTable.put(new Integer(s), fCServerObject);
                    break;
                }
                case 58: {
                    Debug.Print(3, "cChat\n");
                    break;
                }
                case 12: {
                    Debug.Print(3, "cObjClose\n");
                    short s = FCPConnection.MotorolaShort(byArray, 0);
                    if (s != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(s);
                        fCErrorDialog.waitForAction();
                    } else {
                        short s11 = FCPConnection.MotorolaShort(byArray, 2);
                        FCServerObject fCServerObject = (FCServerObject)this.FCObjTable.get(new Integer(s11));
                        if (fCServerObject != null) {
                            fCServerObject.HandleReply(by, byArray);
                        }
                    }
                    break;
                }
                case 34: {
                    short s = FCPConnection.MotorolaShort(byArray, 0);
                    Debug.Print(3, "cSelect rc: " + s + "\n");
                    if (s != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(s);
                        fCErrorDialog.waitForAction();
                    }
                    break;
                }
                case 60: {
                    Debug.Print(3, "cObjOpenUnsol\n");
                    short s = FCPConnection.MotorolaShort(byArray, 0);
                    if (s != 0) {
                        FCErrorDialog fCErrorDialog = new FCErrorDialog(s);
                        fCErrorDialog.waitForAction();
                    } else {
                        int n = FCPConnection.Unsigned(byArray[2]);
                        short s12 = FCPConnection.MotorolaShort(byArray, 4);
                        short s13 = FCPConnection.MotorolaShort(byArray, 6);
                        short s14 = FCPConnection.MotorolaShort(byArray, 34);
                        Debug.Print(5, "ObjOpenReply (cObjOpen) rc:" + s + " ObjType:" + n + " ObjID:" + s12 + " ReqID:" + s13 + " Chatset:" + s14 + "\n");
                        FCServerObject fCServerObject = this.NewByObjType(n, s12, s14);
                        this.FCObjTable.put(new Integer(s12), fCServerObject);
                    }
                    break;
                }
                default: {
                    Debug.Print(3, "Unhandled reply:" + by + "\n");
                    break;
                }
                case 39: 
                case 48: 
                case 54: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
    }

    private void Logout() throws IOException {
        Debug.Print(2, "Logout ");
        byte[] byArray = new byte[8];
        byArray[0] = -22;
        byArray[1] = -22;
        byArray[2] = 2;
        byArray[3] = 5;
        byte[] byArray2 = byArray;
        this.SendPacket(byArray2);
        int n = 5;
        Debug.Print(2, "waiting for reply\n ");
        while (this.IsLoggedIn && n > 0) {
            Debug.Print(2, ".");
            this.Run(10);
            --n;
        }
        if (n <= 0) {
            Debug.Print(2, "timed out\n");
        } else {
            Debug.Print(2, "ok\n");
        }
    }

    static final int MotorolaLong(byte[] byArray, int n) {
        int n2 = (FCPConnection.Unsigned(byArray[n]) << 24) + (FCPConnection.Unsigned(byArray[n + 1]) << 16) + (FCPConnection.Unsigned(byArray[n + 2]) << 8) + FCPConnection.Unsigned(byArray[n + 3]);
        return n2;
    }

    static final short MotorolaShort(byte[] byArray, int n) {
        short s = (short)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
        return s;
    }

    FCServerObject NewByObjType(int n, int n2, short s) {
        CDirNameHandler cDirNameHandler = null;
        Debug.Print(3, "NewByObjType ObjType=" + n + " ObjID=" + n2 + "Charset=" + s + "\n");
        String string = null;
        switch (n) {
            case 7: {
                string = FCCharset.getServerEncoding();
                cDirNameHandler = new CDirList(this, n2, string);
                break;
            }
            case 14: {
                Short s2 = new Short(s);
                string = FCCharset.s2u(s2.toString());
                cDirNameHandler = new ChatObject(this, n2, string);
                break;
            }
            case 15: {
                Short s3 = new Short(s);
                string = FCCharset.s2u(s3.toString());
                cDirNameHandler = new ChatInvite(this, n2, string);
                break;
            }
        }
        return cDirNameHandler;
    }

    public void OpenObject(int n, int n2) throws IOException {
        Debug.Print(3, "OpenObject ObjID:" + n + " Index:" + n2 + "\n");
        byte[] byArray = new byte[14];
        byArray[0] = -22;
        byArray[1] = -22;
        byArray[2] = 2;
        byArray[3] = 7;
        byArray[7] = 6;
        byte[] byArray2 = byArray;
        byArray2[8] = (byte)(n >> 8);
        byArray2[9] = (byte)(n & 0xFF);
        byArray2[10] = (byte)(n2 >> 8);
        byArray2[11] = (byte)(n2 & 0xFF);
        this.SendPacket(byArray2);
    }

    public void OpenObjectRequest(int n, int n2, int n3, String string) {
        this.OpenObjectRequest(n, n2, n3, string, 0);
    }

    public void OpenObjectRequest(int n, int n2, int n3, String string, int n4) {
        byte[] byArray = new byte[16];
        byArray[0] = -22;
        byArray[1] = -22;
        byArray[2] = 2;
        byArray[3] = 7;
        byArray[7] = 8;
        byte[] byArray2 = byArray;
        byArray2[8] = (byte)(n >> 8);
        byArray2[9] = (byte)(n & 0xFF);
        byArray2[10] = (byte)(n2 >> 8);
        byArray2[11] = (byte)(n2 & 0xFF);
        byArray2[12] = (byte)(n4 >> 8);
        byArray2[13] = (byte)(n4 & 0xFF);
        try {
            this.SendPacket(byArray2);
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
    }

    public void OpenURL(String string, int n) throws IOException {
        Debug.Print(3, "OpenURL URL:[" + string + "] Index:" + n + "\n");
        byte[] byArray = new byte[244];
        byArray[0] = -22;
        byArray[1] = -22;
        byArray[2] = 2;
        byArray[3] = 68;
        byArray[7] = -20;
        byte[] byArray2 = byArray;
        byArray2[10] = 0;
        byArray2[11] = 1;
        PackOOQ packOOQ = new PackOOQ();
        int n2 = packOOQ.PackOOQPath(byArray2, 12, string);
        Debug.Print(5, "nDataPacked = " + n2 + "\n");
        byArray2[8] = (byte)(n2 >> 8);
        byArray2[9] = (byte)(n2 & 0xFF);
        Debug.Print(5, "OpenObject Packet:\n");
        Debug.PrintHexBytes(5, byArray2);
        Debug.Print(5, "\n");
        this.SendPacket(byArray2);
    }

    public void PurgeOpenedObject() {
        try {
            Enumeration enumeration = this.FCObjTable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                this.CloseObject(n);
            }
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
    }

    public byte[] ReadPacket() {
        try {
            if (this.HdrBytesRead == 0 && this.is.available() >= 8) {
                this.is.read(this.hdr);
                if (this.hdr[0] != -22 || this.hdr[1] != -22) {
                    Debug.Print(7, "ReadPacket header out of sync:\n");
                    Debug.PrintHexBytes(7, this.hdr);
                    Debug.Print(7, "\n");
                    return null;
                }
                this.PktDataSize = FCPConnection.MotorolaShort(this.hdr, 6);
                Debug.Print(8, "PktDataSize:" + this.PktDataSize + "\n");
                this.HdrBytesRead = 8;
            }
            if (this.HdrBytesRead == 8 && this.is.available() >= this.PktDataSize) {
                this.PktData = new byte[this.PktDataSize];
                this.is.read(this.PktData);
                Debug.Print(8, "Got a packet:");
                Debug.PrintHexBytes(8, this.PktData);
                Debug.Print(8, "\n");
                this.HdrBytesRead = 0;
                return this.PktData;
            }
            return null;
        }
        catch (Exception exception) {
            FCException.handleException(exception);
            return null;
        }
    }

    public void Run() {
        while (true) {
            this.Run(1);
        }
    }

    public void Run(int n) {
        byte[] byArray = null;
        while (n-- > 0) {
            byArray = this.ReadPacket();
            if (byArray == null) {
                Thread.yield();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    FCException.handleException(exception);
                }
                continue;
            }
            this.HandleReply((byte)(this.hdr[3] & 0x7F), byArray);
        }
    }

    public void SendAuthData(String string, short s) {
        byte[] byArray = new byte[420];
        byArray[0] = -22;
        byArray[1] = -22;
        byArray[2] = 2;
        byArray[3] = 9;
        byArray[6] = 1;
        byArray[7] = -100;
        byte[] byArray2 = byArray;
        byArray2[8] = -1;
        byArray2[9] = -6;
        Debug.Print(3, "ReqData.ObjID -6\n");
        byArray2[10] = (byte)(s >> 8);
        byArray2[11] = (byte)(s & 0xFF);
        Debug.Print(3, "ReqData.FieldID " + s + "\n");
        byArray2[16] = (byte)(string.length() + 2 >> 8);
        byArray2[17] = (byte)(string.length() + 2 & 0xFF);
        Debug.Print(3, "ReqData.dObjUpdate.Data.FormRec.Amount " + string.length() + "\n");
        byArray2[18] = 0;
        byArray2[19] = 122;
        this.Util.ModifyMemFromString(byArray2, 20, string);
        int n = string.length() + 20;
        byArray2[6] = (byte)(string.length() + 12 >> 8);
        byArray2[7] = (byte)(string.length() + 12 & 0xFF);
        try {
            this.SendPacket(byArray2, n);
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
    }

    public void SendLoginPacket() {
        byte[] byArray = new byte[48];
        byArray[0] = -22;
        byArray[1] = -22;
        byArray[2] = 1;
        byArray[3] = 4;
        byArray[4] = -126;
        byArray[5] = 124;
        byArray[7] = 40;
        byArray[39] = 13;
        byArray[40] = 24;
        byArray[41] = 56;
        byArray[42] = -108;
        byArray[44] = 4;
        byArray[45] = -22;
        byArray[47] = this.md5_login ? (byte)1 : 0;
        byte[] byArray2 = byArray;
        Debug.Print(3, "SendLoginPacket()\n");
        if (this.UserName.length() > 0) {
            this.Util.ModifyMemFromString(byArray2, 8, this.Util.String2PStr(this.UserName));
        }
        if (!this.md5_login) {
            if (this.UserPassword.length() > 0) {
                this.Util.ModifyMemFromString(byArray2, 24, this.Util.String2PStr(this.UserPassword));
            } else {
                byArray2[43] = (byte)(byArray2[43] | 0x20);
            }
        }
        try {
            Integer n = new Integer(FCCharset.u2s(FCChat.LocaleCharSet));
            Debug.Print(2, "locale in FC charset =" + n + "\n");
            byArray2[44] = (byte)(n >> 8);
            byArray2[45] = (byte)(n & 0xFF);
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
        Debug.Print(2, "Sending Login Request\n");
        if (this.md5_login) {
            this.SendAuthData(this.UserMD5Challenge, (short)1001);
            this.SendAuthData(this.UserMD5Digest, (short)1002);
        }
        try {
            this.SendPacket(byArray2);
        }
        catch (Exception exception) {
            FCException.handleException(exception);
        }
    }

    public void SendPacket(byte[] byArray) throws IOException {
        byArray[2] = (byte)this.XmitSeq++;
        byArray[4] = 0;
        byArray[5] = 0;
        int n = this.CalcCS4(byArray);
        byArray[4] = (byte)(n >> 8);
        byArray[5] = (byte)(n & 0xFF);
        Debug.Print(8, "SendPacket Cmd:" + byArray[3] + "\n");
        Debug.PrintHexBytes(8, byArray);
        Debug.Print(8, "\n");
        this.os.write(byArray);
    }

    public void SendPacket(byte[] byArray, int n) throws IOException {
        byArray[2] = (byte)this.XmitSeq++;
        byArray[4] = 0;
        byArray[5] = 0;
        int n2 = this.CalcCS4(byArray);
        byArray[4] = (byte)(n2 >> 8);
        byArray[5] = (byte)(n2 & 0xFF);
        Debug.Print(8, "SendPacket Cmd:" + byArray[3] + "\n");
        Debug.PrintHexBytes(8, byArray, n);
        Debug.Print(8, "\n");
        this.os.write(byArray, 0, n);
    }

    static final int Unsigned(byte by) {
        return by & 0xFF;
    }

    public boolean getLoginState() {
        return this.IsLoggedIn;
    }

    public boolean getLoginState(int n) {
        if (this.IsLoggedIn) {
            return true;
        }
        this.Run(n);
        return this.IsLoggedIn;
    }
}

